/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.XmlExternalizable;
import jetbrains.buildServer.artifacts.BuildTagRevisionRule;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.log.Loggers;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionRules {
    @NonNls
    public static final String REVISION_RULE_TAG = "revisionRule";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String REVISION_ATTR = "revision";
    @NonNls
    public static final String BRANCH_ATTR = "branch";
    public static final String BUILD_ID_SUFFIX = ".tcbuildid";
    public static final String BUILD_TAG_SUFFIX = ".tcbuildtag";
    public static final String LAST_PINNED_NAME = "lastPinned";
    public static final String LAST_SUCCESSFUL_NAME = "lastSuccessful";
    public static final String LAST_FINISHED_NAME = "lastFinished";
    public static final String LAST_FINISHED_SAME_CHAIN_NAME = "sameChainOrLastFinished";
    public static final String BUILD_NUMBER_NAME = "buildNumber";
    public static final String BUILD_ID_NAME = "buildId";
    public static final String BUILD_TAG_NAME = "buildTag";
    private static final Pattern BUILD_ID_PATTERN = Pattern.compile("([0-9]+)(:id|" + jetbrains.buildServer.util.StringUtil.escapeForRegex(".tcbuildid") + ")");
    @NotNull
    public static final RevisionRule LAST_PINNED_RULE = new LastPinnedRule(null);
    @NotNull
    public static final RevisionRule LAST_SUCCESSFUL_RULE = new LastSuccessfulRule(null);
    @NotNull
    public static final RevisionRule LAST_FINISHED_RULE = new LastFinishedRule(null);
    @NotNull
    public static final RevisionRule LAST_FINISHED_SAME_CHAIN_RULE = new LastFinishedSameChainRule();

    private RevisionRules() {
    }

    @NotNull
    public static RevisionRule newBuildNumberRule(String buildNumber) {
        BuildNumberRule buildNumberRule = new BuildNumberRule(buildNumber);
        if (buildNumberRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBuildNumberRule"));
        }
        return buildNumberRule;
    }

    @NotNull
    public static RevisionRule newBuildTagRule(@Nullable String buildTagParam) {
        RevisionRule revisionRule = RevisionRules.newBuildTagRule(buildTagParam, null);
        if (revisionRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBuildTagRule"));
        }
        return revisionRule;
    }

    public static RevisionRule newBuildTagRule(@Nullable String buildTagParam, @Nullable String branch) {
        String buildTag = buildTagParam != null ? (buildTagParam.endsWith(BUILD_TAG_SUFFIX) ? buildTagParam.substring(0, buildTagParam.lastIndexOf(BUILD_TAG_SUFFIX)).trim() : buildTagParam.trim()) : "";
        return new BuildTagRevisionRuleImpl(buildTag, branch);
    }

    @NotNull
    public static RevisionRule newBuildIdRule(long buildId, @Nullable String buildNumber) {
        BuildIdRule buildIdRule = new BuildIdRule(buildId, buildNumber);
        if (buildIdRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBuildIdRule"));
        }
        return buildIdRule;
    }

    @NotNull
    public static RevisionRule newRevisionRule(@NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "jetbrains/buildServer/artifacts/RevisionRules", "newRevisionRule"));
        }
        RevisionRule revisionRule = RevisionRules.newBranchRevisionRule(name, value, null);
        if (revisionRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newRevisionRule"));
        }
        return revisionRule;
    }

    @NotNull
    public static RevisionRule newBranchRevisionRule(@NotNull String name, @Nullable String value, @Nullable String branch) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
        }
        if (LAST_FINISHED_NAME.equals(name)) {
            LastFinishedRule lastFinishedRule = new LastFinishedRule(branch);
            if (lastFinishedRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
            }
            return lastFinishedRule;
        }
        if (LAST_FINISHED_SAME_CHAIN_NAME.equals(name)) {
            RevisionRule revisionRule = LAST_FINISHED_SAME_CHAIN_RULE;
            if (revisionRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
            }
            return revisionRule;
        }
        if (LAST_PINNED_NAME.equals(name)) {
            LastPinnedRule lastPinnedRule = new LastPinnedRule(branch);
            if (lastPinnedRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
            }
            return lastPinnedRule;
        }
        if (LAST_SUCCESSFUL_NAME.equals(name)) {
            LastSuccessfulRule lastSuccessfulRule = new LastSuccessfulRule(branch);
            if (lastSuccessfulRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
            }
            return lastSuccessfulRule;
        }
        if (BUILD_TAG_NAME.equals(name)) {
            RevisionRule revisionRule = RevisionRules.newBuildTagRule(value, branch);
            if (revisionRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
            }
            return revisionRule;
        }
        RevisionRule revisionRule = RevisionRules.newBuildNumberRule(value);
        if (revisionRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
        }
        return revisionRule;
    }

    @Nullable
    public static RevisionRule newRevisionRule(@NotNull String revision) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", REVISION_ATTR, "jetbrains/buildServer/artifacts/RevisionRules", "newRevisionRule"));
        }
        return RevisionRules.newBranchRevisionRule(revision, null);
    }

    @Nullable
    public static RevisionRule newBranchRevisionRule(@NotNull String revision, @Nullable String branch) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", REVISION_ATTR, "jetbrains/buildServer/artifacts/RevisionRules", "newBranchRevisionRule"));
        }
        Matcher matcher = BUILD_ID_PATTERN.matcher(revision);
        if (matcher.matches()) {
            String buildIdStr = matcher.group(1);
            try {
                return RevisionRules.newBuildIdRule(Long.parseLong(buildIdStr), null);
            }
            catch (NumberFormatException e) {
                Loggers.SERVER.warn("Failed to parse build id from the revision: " + revision);
                return null;
            }
        }
        if (revision.endsWith(BUILD_TAG_SUFFIX)) {
            return RevisionRules.newBuildTagRule(revision, branch);
        }
        String rev = revision;
        int lastDotIdx = revision.lastIndexOf(46);
        if (lastDotIdx != -1) {
            rev = revision.substring(lastDotIdx);
        }
        if (LAST_PINNED_RULE.getRevision().endsWith(rev)) {
            return new LastPinnedRule(branch);
        }
        if (LAST_FINISHED_RULE.getRevision().endsWith(rev)) {
            return new LastFinishedRule(branch);
        }
        if (LAST_SUCCESSFUL_RULE.getRevision().endsWith(rev)) {
            return new LastSuccessfulRule(branch);
        }
        if (LAST_FINISHED_SAME_CHAIN_RULE.getRevision().endsWith(rev)) {
            return LAST_FINISHED_SAME_CHAIN_RULE;
        }
        return RevisionRules.newBuildNumberRule(revision);
    }

    private static final class BuildTagRevisionRuleImpl
    extends BuildTagRevisionRule {
        private final String myBuildTag;

        public BuildTagRevisionRuleImpl(@NotNull String buildTag, @Nullable String branch) {
            if (buildTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RevisionRules.BUILD_TAG_NAME, "jetbrains/buildServer/artifacts/RevisionRules$BuildTagRevisionRuleImpl", "<init>"));
            }
            super(RevisionRules.BUILD_TAG_NAME, "Last build with tag: '" + buildTag + "'", buildTag + RevisionRules.BUILD_TAG_SUFFIX, branch);
            this.myBuildTag = buildTag;
        }

        @NotNull
        public String getBuildTag() {
            String string = this.myBuildTag;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/artifacts/RevisionRules$BuildTagRevisionRuleImpl", "getBuildTag"));
            }
            return string;
        }
    }

    private static final class BuildIdRule
    extends AbstractRevisionRule {
        private BuildIdRule(long buildId, @Nullable String buildNumber) {
            super(RevisionRules.BUILD_ID_NAME, BuildIdRule.createDescription(buildId, buildNumber), buildId + RevisionRules.BUILD_ID_SUFFIX, null);
        }

        private static String createDescription(long buildId, @Nullable String buildNumber) {
            return !jetbrains.buildServer.util.StringUtil.isEmptyOrSpaces((String)buildNumber) ? "Build #" + buildNumber + " [id " + buildId + "]" : "Build with id: " + buildId;
        }
    }

    private static final class BuildNumberRule
    extends AbstractRevisionRule {
        private BuildNumberRule(String buildNumber) {
            super(RevisionRules.BUILD_NUMBER_NAME, "Build #" + buildNumber, buildNumber, null);
        }
    }

    private static final class LastFinishedSameChainRule
    extends AbstractRevisionRule {
        private LastFinishedSameChainRule() {
            super(RevisionRules.LAST_FINISHED_SAME_CHAIN_NAME, "Build from the same chain", "latest.sameChainOrLastFinished", null);
        }
    }

    private static final class LastFinishedRule
    extends AbstractRevisionRule {
        private LastFinishedRule(@Nullable String branch) {
            super(RevisionRules.LAST_FINISHED_NAME, "Last finished build", "latest.lastFinished", branch);
        }
    }

    private static final class LastSuccessfulRule
    extends AbstractRevisionRule {
        private LastSuccessfulRule(@Nullable String branch) {
            super(RevisionRules.LAST_SUCCESSFUL_NAME, "Last successful build", "latest.lastSuccessful", branch);
        }
    }

    private static final class LastPinnedRule
    extends AbstractRevisionRule {
        private LastPinnedRule(@Nullable String branch) {
            super(RevisionRules.LAST_PINNED_NAME, "Last pinned build", "latest.lastPinned", branch);
        }
    }

    public static abstract class AbstractRevisionRule
    implements RevisionRule,
    XmlExternalizable {
        private final String myName;
        private final String myDescription;
        private final String myRevision;
        private final String myBranch;

        protected AbstractRevisionRule(@NotNull String name, @NotNull String description, @Nullable String revision, @Nullable String branch) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RevisionRules.NAME_ATTR, "jetbrains/buildServer/artifacts/RevisionRules$AbstractRevisionRule", "<init>"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "jetbrains/buildServer/artifacts/RevisionRules$AbstractRevisionRule", "<init>"));
            }
            this.myName = name;
            this.myDescription = description;
            this.myRevision = revision;
            this.myBranch = branch;
        }

        public String getBranch() {
            return this.myBranch;
        }

        public String getName() {
            return this.myName;
        }

        public String getRevision() {
            return this.myRevision;
        }

        public String getDescription() {
            if (StringUtil.isEmpty((String)this.myBranch)) {
                return this.myDescription;
            }
            return this.myDescription + ", branch: '" + this.myBranch + "'";
        }

        public void writeTo(Element parentElement) {
            Element revisionRule = new Element(RevisionRules.REVISION_RULE_TAG);
            parentElement.addContent((Content)revisionRule);
            revisionRule.setAttribute(RevisionRules.NAME_ATTR, this.getName());
            revisionRule.setAttribute(RevisionRules.REVISION_ATTR, this.getRevision());
            if (this.myBranch != null) {
                revisionRule.setAttribute(RevisionRules.BRANCH_ATTR, this.myBranch);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RevisionRule rule = (RevisionRule)o;
            return this.getName().equals(rule.getName()) && jetbrains.buildServer.util.StringUtil.emptyIfNull(this.getRevision()).equals(jetbrains.buildServer.util.StringUtil.emptyIfNull(rule.getRevision())) && jetbrains.buildServer.util.StringUtil.emptyIfNull(this.myBranch).equals(jetbrains.buildServer.util.StringUtil.emptyIfNull(rule.getBranch()));
        }

        public int hashCode() {
            int result = this.getName().hashCode();
            result = 31 * result + jetbrains.buildServer.util.StringUtil.emptyIfNull(this.getRevision()).hashCode();
            result = 31 * result + jetbrains.buildServer.util.StringUtil.emptyIfNull(this.myBranch).hashCode();
            return result;
        }

        public String toString() {
            return "AbstractRevisionRule{myName='" + this.myName + '\'' + ", myDescription='" + this.myDescription + '\'' + ", myRevision='" + this.myRevision + '\'' + ", myBranch='" + this.myBranch + '\'' + '}';
        }
    }
}

