/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<T> myCurrent;
    private final Iterator<Iterator<T>> myIterators;

    public CompositeIterator(@NotNull Collection<Iterator<T>> iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "jetbrains/buildServer/dataStructures/CompositeIterator", "<init>"));
        }
        this.myCurrent = null;
        this.myIterators = new LinkedList<Iterator<T>>(iterators).iterator();
    }

    public CompositeIterator(@NotNull Iterator<Iterator<T>> iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterators", "jetbrains/buildServer/dataStructures/CompositeIterator", "<init>"));
        }
        this.myCurrent = null;
        this.myIterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.myCurrent == null) {
                if (this.myIterators.hasNext()) {
                    this.myCurrent = this.myIterators.next();
                } else {
                    return false;
                }
            }
            if (this.myCurrent.hasNext()) {
                return true;
            }
            this.myCurrent = null;
        }
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.myCurrent.next();
        }
        throw new NoSuchElementException("all elements are red");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("collection is readonly");
    }
}

