/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.dataStructures.CompositeCollection;
import jetbrains.buildServer.dataStructures.CompositeSet;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMap<TK, TV>
implements Map<TK, TV> {
    private final Collection<Map<TK, TV>> myMaps;

    public CompositeMap(@NotNull Collection<Map<TK, TV>> maps) {
        if (maps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maps", "jetbrains/buildServer/dataStructures/CompositeMap", "<init>"));
        }
        this.myMaps = maps;
    }

    @Override
    public int size() {
        int sz = 0;
        for (Map<TK, TV> map : this.myMaps) {
            sz += map.size();
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Map<TK, TV> map : this.myMaps) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<TK, TV> map : this.myMaps) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<TK, TV> map : this.myMaps) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TV get(Object key) {
        for (Map<TK, TV> map : this.myMaps) {
            TV val = map.get(key);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public TV put(TK key, TV value) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public TV remove(Object key) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void putAll(Map<? extends TK, ? extends TV> m) {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("map is readonly");
    }

    @Override
    public Set<TK> keySet() {
        ArrayList sets = new ArrayList(this.myMaps.size());
        for (Map<TK, TV> map : this.myMaps) {
            sets.add(map.keySet());
        }
        return new CompositeSet(sets);
    }

    @Override
    public Collection<TV> values() {
        ArrayList<Collection<TV>> sets = new ArrayList<Collection<TV>>(this.myMaps.size());
        for (Map<TK, TV> map : this.myMaps) {
            sets.add(map.values());
        }
        return new CompositeCollection(sets);
    }

    @Override
    public Set<Map.Entry<TK, TV>> entrySet() {
        ArrayList sets = new ArrayList(this.myMaps.size());
        for (Map<TK, TV> map : this.myMaps) {
            sets.add(map.entrySet());
        }
        Collections.reverse(sets);
        return new CompositeSet<Map.Entry<TK, TV>>(sets);
    }
}

