/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.dataStructures;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.buildServer.dataStructures.DecoratingIterator;
import jetbrains.buildServer.dataStructures.Mapper;
import jetbrains.buildServer.dataStructures.NotNullMapper;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DecoratingCollectionBase<T, Q>
implements Collection<T> {
    protected final Collection<Q> myCollection;
    private final Mapper<Q, T> myMapper;

    public DecoratingCollectionBase(@NotNull Collection<Q> collection, @NotNull Mapper<Q, T> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/dataStructures/DecoratingCollectionBase", "<init>"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "jetbrains/buildServer/dataStructures/DecoratingCollectionBase", "<init>"));
        }
        this.myCollection = collection;
        this.myMapper = mapper;
    }

    @Override
    public int size() {
        if (this.myMapper instanceof NotNullMapper) {
            return this.myCollection.size();
        }
        int sz = 0;
        for (Q q : this.myCollection) {
            if (this.myMapper.mapKey(q) == null) continue;
            ++sz;
        }
        return sz;
    }

    @Override
    public boolean isEmpty() {
        for (Q q : this.myCollection) {
            if (this.myMapper.mapKey(q) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public Iterator<T> iterator() {
        return new DecoratingIterator<T, Q>(this.myCollection.iterator(), this.myMapper);
    }

    @Override
    public Object[] toArray() {
        Object[] os = new Object[this.size()];
        int i = 0;
        for (Q q : this.myCollection) {
            T t = this.myMapper.mapKey(q);
            if (t == null) continue;
            os[i++] = t;
        }
        return os;
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        E[] result = a;
        for (Q q : this.myCollection) {
            T t = this.myMapper.mapKey(q);
            if (t == null) continue;
            result[i++] = t;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("collection is readonly");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("collection is readonly");
    }
}

