/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializerUtil {
    private static final String STD_EX_SUFFIX = "Valid property list format is (name( )*=( )*'escaped_value'( )*)* where escape symbol is \"|\"";
    @Deprecated
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        public char unescape(char c) {
            switch (c) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 'x': {
                    return '\u0085';
                }
                case 'l': {
                    return '\u2028';
                }
                case 'p': {
                    return '\u2029';
                }
                case '\'': {
                    return '\'';
                }
                case '|': {
                    return '|';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        public char escapeCharacter() {
            return '|';
        }
    };
    public static final EscapeInfoProvider2 STD_ESCAPER2 = new EscapeInfoProvider2(){

        @Nullable
        public String escape(char c) {
            switch (c) {
                case '\n': {
                    return "n";
                }
                case '\r': {
                    return "r";
                }
                case '\u0085': {
                    return "0x0085";
                }
                case '\u2028': {
                    return "0x2028";
                }
                case '\u2029': {
                    return "0x2029";
                }
                case '|': {
                    return "|";
                }
                case '\'': {
                    return "'";
                }
                case '[': {
                    return "[";
                }
                case ']': {
                    return "]";
                }
            }
            return null;
        }

        @Nullable
        public UnescapeResult unescape(@NotNull String str, int startPos) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$2", "unescape"));
            }
            switch (str.charAt(startPos)) {
                case 'n': {
                    return new UnescapeResult('\n', 1);
                }
                case 'r': {
                    return new UnescapeResult('\r', 1);
                }
                case 'x': {
                    return new UnescapeResult('\u0085', 1);
                }
                case 'l': {
                    return new UnescapeResult('\u2028', 1);
                }
                case 'p': {
                    return new UnescapeResult('\u2029', 1);
                }
                case '\'': {
                    return new UnescapeResult('\'', 1);
                }
                case '|': {
                    return new UnescapeResult('|', 1);
                }
                case '[': {
                    return new UnescapeResult('[', 1);
                }
                case ']': {
                    return new UnescapeResult(']', 1);
                }
                case '0': {
                    if (startPos + 5 >= str.length() || str.charAt(startPos + 1) != 'x') break;
                    try {
                        return new UnescapeResult((char)Integer.parseInt(str.substring(startPos + 2, startPos + 6), 16), 6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        public char escapeCharacter() {
            return '|';
        }
    };

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        return map;
    }

    @Deprecated
    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        return MapSerializerUtil.propertiesToString(props, MapSerializerUtil.convertProvider(escaper));
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> props, @NotNull EscapeInfoProvider2 escaper) {
        if (props == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "props", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "propertiesToString"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "propertiesToString"));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(MapSerializerUtil.escapeStr(entry.getKey(), escaper));
            builder.append('=');
            builder.append('\'').append(MapSerializerUtil.escapeStr(entry.getValue(), escaper)).append('\'');
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "propertiesToString"));
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        Map<String, String> map = MapSerializerUtil.stringToProperties(string, MapSerializerUtil.convertProvider(escaper), strictNameCheck);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        String currentString = string;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        while (currentString.length() > 0) {
            int nameSep = currentString.indexOf("=");
            if (nameSep == -1) {
                throw new ParseException("Property value not found\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape symbol is \"|\"", 0);
            }
            String name = currentString.substring(0, nameSep).trim();
            MapSerializerUtil.checkPropName(name, strictNameCheck);
            currentString = currentString.substring(nameSep + 1).trim();
            if (currentString.startsWith("'")) {
                int endOfValue = MapSerializerUtil.indexOf(currentString = currentString.substring(1), '\'', escaper);
                if (endOfValue >= 0) {
                    String escapedValue = currentString.substring(0, endOfValue);
                    currentString = currentString.substring(endOfValue + 1).trim();
                    result.put(name, MapSerializerUtil.unescapeStr(escapedValue, escaper));
                    continue;
                }
                throw new ParseException("Value should end with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape symbol is \"|\"", 0);
            }
            throw new ParseException("Value should start with \"'\"\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape symbol is \"|\"", 0);
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "stringToProperties"));
        }
        return linkedHashMap;
    }

    private static void checkPropName(@NotNull String name, boolean strict) throws ParseException {
        boolean isCorrect;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "checkPropName"));
        }
        boolean bl = strict ? MapSerializerUtil.isValidJavaIdentifier(name) : (isCorrect = !MapSerializerUtil.hasSpaces(name));
        if (!isCorrect) {
            throw new ParseException("Incorrect property name.\nValid property list format is (name( )*=( )*'escaped_value'( )*)* where escape symbol is \"|\"", 0);
        }
    }

    private static boolean hasSpaces(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "hasSpaces"));
        }
        return name.indexOf(32) >= 0;
    }

    @Deprecated
    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        return MapSerializerUtil.indexOf(currentString, findWhat, MapSerializerUtil.convertProvider(escaper));
    }

    public static int indexOf(@NotNull String currentString, char findWhat, @NotNull EscapeInfoProvider2 escaper) {
        if (currentString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentString", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "indexOf"));
        }
        if (escaper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "escaper", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "indexOf"));
        }
        int length = currentString.length();
        for (int i = 0; i < length; ++i) {
            UnescapeResult unescaped;
            char currentChar = currentString.charAt(i);
            if (currentChar == escaper.escapeCharacter() && i + 1 < length && (unescaped = escaper.unescape(currentString, i + 1)) != null) {
                i += unescaped.getEscapedLength();
                continue;
            }
            if (currentChar != findWhat) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidJavaIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "isValidJavaIdentifier"));
        }
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String escapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @NotNull
    private static EscapeInfoProvider2 convertProvider(final @NotNull EscapeInfoProvider p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "convertProvider"));
        }
        EscapeInfoProvider2 escapeInfoProvider2 = new EscapeInfoProvider2(){

            @Nullable
            public String escape(char c) {
                char result = p.escape(c);
                return result == '\u0000' ? null : String.valueOf(result);
            }

            @Nullable
            public UnescapeResult unescape(@NotNull String str, int startPos) {
                if (str == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$3", "unescape"));
                }
                char result = p.unescape(str.charAt(startPos));
                return result == '\u0000' ? null : new UnescapeResult(result, 1);
            }

            public char escapeCharacter() {
                return p.escapeCharacter();
            }
        };
        if (escapeInfoProvider2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "convertProvider"));
        }
        return escapeInfoProvider2;
    }

    @Nullable
    public static String escapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "escapeStr"));
        }
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String escaped = p.escape(c);
            if (escaped != null) {
                resultChars[resultPos++] = p.escapeCharacter();
                int escapedLength = escaped.length();
                System.arraycopy(escaped.toCharArray(), 0, resultChars, resultPos, escapedLength);
                resultPos += escapedLength;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(@NotNull String str, @NotNull EscapeInfoProvider2 p) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "calcFinalEscapedStringCount"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "calcFinalEscapedStringCount"));
        }
        int result = 0;
        for (int i = 0; i < str.length(); ++i) {
            String escapePresentation = p.escape(str.charAt(i));
            if (escapePresentation != null) {
                result += 1 + escapePresentation.length();
                continue;
            }
            ++result;
        }
        return result;
    }

    @Deprecated
    public static String unescapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.unescapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @Nullable
    public static String unescapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "unescapeStr"));
        }
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalUnescapedStringCount(str, p);
        int len = str.length();
        if (len == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            UnescapeResult unescaped;
            char c = str.charAt(i);
            if (c == p.escapeCharacter() && i + 1 < len && (unescaped = p.unescape(str, i + 1)) != null) {
                c = unescaped.getChar();
                i += unescaped.getEscapedLength();
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(@NotNull String str, @NotNull EscapeInfoProvider2 p) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "calcFinalUnescapedStringCount"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil", "calcFinalUnescapedStringCount"));
        }
        int result = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            UnescapeResult unescaped;
            if (str.charAt(i) == p.escapeCharacter() && i + 1 < len && (unescaped = p.unescape(str, i + 1)) != null) {
                i += unescaped.getEscapedLength();
            }
            ++result;
        }
        return result;
    }

    public static class UnescapeResult {
        private final char myChar;
        private final int myEscapedLength;

        public UnescapeResult(char ch, int escapedLength) {
            this.myChar = ch;
            this.myEscapedLength = escapedLength;
        }

        public char getChar() {
            return this.myChar;
        }

        public int getEscapedLength() {
            return this.myEscapedLength;
        }
    }

    public static interface EscapeInfoProvider2 {
        @Nullable
        public String escape(char var1);

        @Nullable
        public UnescapeResult unescape(@NotNull String var1, int var2);

        public char escapeCharacter();
    }

    @Deprecated
    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char unescape(char var1);

        public char escapeCharacter();
    }
}

