/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends MessageWithAttributes {
    Message() {
    }

    public Message(@NotNull String text, @NotNull String status, @Nullable String errDetails) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/Message", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "jetbrains/buildServer/messages/serviceMessages/Message", "<init>"));
        }
        super("message", Message.createMap(text, status, errDetails));
    }

    private static Map<String, String> createMap(@NotNull String text, @NotNull String status, @Nullable String errDetails) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/Message", "createMap"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "jetbrains/buildServer/messages/serviceMessages/Message", "createMap"));
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        res.put("text", text);
        res.put("status", status);
        if (errDetails != null) {
            res.put("errorDetails", errDetails);
        }
        return res;
    }

    public String getStatus() {
        String status = this.getAttributeValue("status");
        if (status != null) {
            return status;
        }
        return "NORMAL";
    }

    public String getText() {
        return this.getAttributeValue("text");
    }

    public String getErrorDetails() {
        return this.getAttributeValue("errorDetails");
    }

    @Override
    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "jetbrains/buildServer/messages/serviceMessages/Message", "visit"));
        }
        visitor.visitMessageWithStatus(this);
    }
}

