/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import jetbrains.buildServer.messages.BuildMessage1;
import jetbrains.buildServer.messages.DefaultMessagesInfo;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.TextMessageProcessor;
import org.jetbrains.annotations.NotNull;

public class ServiceMessagesProcessor {
    public static void processTextMessage(final @NotNull BuildMessage1 originalMessage, final @NotNull TextMessageProcessor processor) {
        if (originalMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalMessage", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor", "processTextMessage"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor", "processTextMessage"));
        }
        Object value = originalMessage.getValue();
        if (!"Text".equals(originalMessage.getTypeId()) || value == null || !(value instanceof String) || ((String)value).trim().length() == 0) {
            processor.processOriginalMessageIsNotTextMessage(originalMessage);
            return;
        }
        ServiceMessage.parse((String)value, new ServiceMessageParserCallback(){

            public void regularText(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor$1", "regularText"));
                }
                BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, text);
                processor.processText(partialOriginalMessage);
            }

            public void serviceMessage(@NotNull ServiceMessage message) {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor$1", "serviceMessage"));
                }
                BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, message.asString());
                processor.processServiceMessage(message, partialOriginalMessage);
            }

            public void parseException(@NotNull ParseException parseException, @NotNull String text) {
                if (parseException == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parseException", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor$1", "parseException"));
                }
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor$1", "parseException"));
                }
                BuildMessage1 partialOriginalMessage = ServiceMessagesProcessor.makeNewTextMessage(originalMessage, text);
                processor.processParseException(parseException, partialOriginalMessage);
            }
        });
    }

    @NotNull
    private static BuildMessage1 makeNewTextMessage(@NotNull BuildMessage1 m, @NotNull String text) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor", "makeNewTextMessage"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor", "makeNewTextMessage"));
        }
        BuildMessage1 buildMessage1 = DefaultMessagesInfo.createTextMessage(m, text);
        if (buildMessage1 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/messages/serviceMessages/ServiceMessagesProcessor", "makeNewTextMessage"));
        }
        return buildMessage1;
    }
}

