/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters;

import java.util.Map;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.ValueResolver;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullValueResolver
implements ValueResolver {
    @Override
    @NotNull
    public ProcessingResult resolve(final @NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/NullValueResolver", "resolve"));
        }
        ProcessingResult processingResult = new ProcessingResult(){

            public boolean isModified() {
                return false;
            }

            @NotNull
            public String getResult() {
                String string = value;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/NullValueResolver$1", "getResult"));
                }
                return string;
            }

            public boolean isFullyResolved() {
                return !ReferencesResolverUtil.containsReference(value, new String[0], true);
            }
        };
        if (processingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/NullValueResolver", "resolve"));
        }
        return processingResult;
    }

    @Override
    @NotNull
    public Map<String, String> resolve(@NotNull Map<String, String> unresolved) {
        if (unresolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolved", "jetbrains/buildServer/parameters/NullValueResolver", "resolve"));
        }
        Map<String, String> map = unresolved;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/NullValueResolver", "resolve"));
        }
        return map;
    }
}

