/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasParametersProvider
implements MapParametersProvider {
    private final Map<String, String> myAliases;
    private final MapParametersProvider mySource;

    public AliasParametersProvider(MapParametersProvider source) {
        this.mySource = source;
        this.myAliases = new HashMap<String, String>();
    }

    @Override
    public int size() {
        return this.mySource.size();
    }

    @Override
    public Map<String, String> getAll() {
        HashMap<String, String> result = new HashMap<String, String>(this.mySource.size() + this.myAliases.size());
        result.putAll(this.mySource.getAll());
        return result;
    }

    @Override
    public String get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/AliasParametersProvider", "get"));
        }
        String result = this.mySource.get(key);
        if (result != null) {
            return result;
        }
        String aliasName = this.myAliases.get(key);
        if (aliasName != null) {
            return this.mySource.get(aliasName);
        }
        return null;
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/AliasParametersProvider", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/impl/AliasParametersProvider", "put"));
        }
        this.mySource.put(key, value);
    }

    @Override
    @Nullable
    public String remove(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/AliasParametersProvider", "remove"));
        }
        String removedInSource = this.mySource.remove(key);
        if (removedInSource != null) {
            this.myAliases.remove(key);
            return removedInSource;
        }
        String aliasName = this.myAliases.remove(key);
        if (aliasName != null) {
            return this.mySource.get(aliasName);
        }
        return null;
    }

    @Override
    public void putAll(@NotNull Map<String, String> fromMap) {
        if (fromMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromMap", "jetbrains/buildServer/parameters/impl/AliasParametersProvider", "putAll"));
        }
        this.mySource.putAll(fromMap);
    }

    public void addAlias(String alias, String originalName) {
        this.myAliases.put(alias, originalName);
    }

    public String toString() {
        return super.toString() + " (source: " + this.mySource.toString() + ", aliases: " + this.myAliases.toString() + ")";
    }
}

