/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.ArrayList;
import java.util.List;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;

public class CompositeResolver
implements ParameterResolver {
    private final List<ParameterResolver> myResolvers = new ArrayList<ParameterResolver>();

    @NotNull
    public ProcessingResult resolve(@NotNull String key, @NotNull String value, @NotNull ParametersProvider parameters) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/CompositeResolver", "resolve"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/impl/CompositeResolver", "resolve"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "jetbrains/buildServer/parameters/impl/CompositeResolver", "resolve"));
        }
        ProcessingResultImpl result = new ProcessingResultImpl(value, false, true);
        for (int i = 0; i < this.myResolvers.size(); ++i) {
            ProcessingResult evalResult = this.myResolvers.get(i).resolve(key, value, parameters);
            if (!result.isModified() && evalResult.isModified()) {
                result.setModified(true);
                result.setResult(evalResult.getResult());
            }
            result.setFullyResolved(result.isFullyResolved() && evalResult.isFullyResolved());
            if (!result.isFullyResolved() && result.isModified()) break;
        }
        ProcessingResultImpl processingResultImpl = result;
        if (processingResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/CompositeResolver", "resolve"));
        }
        return processingResultImpl;
    }

    public void append(ParameterResolver resolver) {
        this.myResolvers.add(resolver);
    }
}

