/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.ParametersInOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersInOutList {
    @NotNull
    private final List<ParametersInOut> myList = new ArrayList<ParametersInOut>();

    public void addParameters(@NotNull ParametersInOut parametersInOut) {
        if (parametersInOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersInOut", "jetbrains/buildServer/parameters/impl/ParametersInOutList", "addParameters"));
        }
        this.myList.add(parametersInOut);
    }

    public void resolveParameters(@NotNull ParameterResolver resolver, @Nullable String resultName) {
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "jetbrains/buildServer/parameters/impl/ParametersInOutList", "resolveParameters"));
        }
        this.performProcessing(resolver, this.fullyResolvedConsideringUnresolved(), resultName);
        this.performProcessing(resolver, this.allFullyResolved(), resultName);
        this.performProcessing(resolver, this.allFullyResolvedAndPartiallyResolved(), resultName);
        for (ParametersInOut paramList : this.myList) {
            if (resultName != null && !paramList.getName().equals(resultName)) continue;
            paramList.resolvingFinished();
        }
    }

    private void performProcessing(@NotNull ParameterResolver resolver, @NotNull ParametersProvider dictionary, @Nullable String resultName) {
        int resolvedInSinglePass;
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "jetbrains/buildServer/parameters/impl/ParametersInOutList", "performProcessing"));
        }
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "jetbrains/buildServer/parameters/impl/ParametersInOutList", "performProcessing"));
        }
        do {
            resolvedInSinglePass = 0;
            for (ParametersInOut params : this.myList) {
                resolvedInSinglePass += params.resolveParametersInSinglePass(dictionary, resolver);
            }
        } while (resolvedInSinglePass > 0 && !this.isAllResolved(resultName));
    }

    private boolean isAllResolved(@Nullable String resultName) {
        for (ParametersInOut parametersInOut : this.myList) {
            if (resultName != null && !parametersInOut.getName().equals(resultName) || parametersInOut.getNotFullyResolved().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private ParametersProvider allFullyResolved() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        for (ParametersInOut parametersInOut : this.myList) {
            result.appendParametersProvider(parametersInOut.getFullyResolved());
        }
        return result;
    }

    private ParametersProvider allFullyResolvedAndPartiallyResolved() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        for (ParametersInOut parametersInOut : this.myList) {
            result.appendParametersProvider(parametersInOut.getFullyResolved());
            result.appendParametersProvider(parametersInOut.getPartlyResolved());
        }
        return result;
    }

    private ParametersProvider fullyResolvedConsideringUnresolved() {
        return new ParametersProvider(){

            @Override
            public String get(@NotNull String key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/ParametersInOutList$1", "get"));
                }
                for (ParametersInOut parametersInOut : ParametersInOutList.this.myList) {
                    String parameter = parametersInOut.getFullyResolved().get(key);
                    if (parameter != null) {
                        return parameter;
                    }
                    if (parametersInOut.getNotFullyResolved().get(key) == null) continue;
                    return null;
                }
                return null;
            }

            @Override
            public int size() {
                return this.getAll().size();
            }

            @Override
            public Map<String, String> getAll() {
                HashMap<String, String> result = new HashMap<String, String>();
                CompositeParametersProviderImpl excluded = new CompositeParametersProviderImpl();
                for (ParametersInOut parametersInOut : ParametersInOutList.this.myList) {
                    ParametersInOutList.addFiltered(result, parametersInOut.getFullyResolved().getAll(), excluded);
                    excluded.appendParametersProvider(parametersInOut.getNotFullyResolved());
                }
                return result;
            }
        };
    }

    private static void addFiltered(Map<String, String> to, Map<String, String> from, ParametersProvider toExclude) {
        for (Map.Entry<String, String> parameter : from.entrySet()) {
            String key = parameter.getKey();
            if (to.get(key) != null || toExclude.get(key) != null) continue;
            to.put(key, parameter.getValue());
        }
    }

    public String toString() {
        return super.toString() + " (" + this.myList.toString() + ")";
    }
}

