/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import jetbrains.buildServer.serverSide.FileWatchingPropertiesModel;
import jetbrains.buildServer.serverSide.TeamCityServerProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamCityServerPropertiesModel
extends FileWatchingPropertiesModel {
    private final Map<String, String> mySystemProps;

    public TeamCityServerPropertiesModel() {
        this(TeamCityServerProperties.getDataPath());
    }

    public TeamCityServerPropertiesModel(@NotNull String dataPath) {
        if (dataPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPath", "jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel", "<init>"));
        }
        super(new File(new File(dataPath, "config"), "internal.properties"));
        this.mySystemProps = Collections.unmodifiableMap(TeamCityServerPropertiesModel.propertiesToMap(System.getProperties()));
    }

    @Override
    @Nullable
    protected String getSystemProperty(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel", "getSystemProperty"));
        }
        if (this.mySystemProps == null) {
            return System.getProperty(key);
        }
        return this.mySystemProps.get(key);
    }

    @Override
    @NotNull
    public Map<String, String> getSystemProperties() {
        if (this.mySystemProps == null) {
            Map<String, String> map = TeamCityServerPropertiesModel.propertiesToMap(System.getProperties());
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel", "getSystemProperties"));
            }
            return map;
        }
        Map<String, String> map = this.mySystemProps;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/TeamCityServerPropertiesModel", "getSystemProperties"));
        }
        return map;
    }
}

