/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class Dates {
    public static final String DEFAULT_DATE_FORMAT = "dd MMM yy HH:mm";
    public static final int JAN = 0;
    public static final int FEB = 1;
    public static final int MAR = 2;
    public static final int APR = 3;
    public static final int MAY = 4;
    public static final int JUN = 5;
    public static final int JUL = 6;
    public static final int AUG = 7;
    public static final int SEP = 8;
    public static final int OCT = 9;
    public static final int NOV = 10;
    public static final int DEC = 11;
    private static final String DEFAULT_TIME_ZONE = "Europe/Prague";
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private static final SimpleDateFormat formalDateFormatter = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
    private static final SimpleDateFormat formalTimeFormatter = new SimpleDateFormat("yyyyMMdd.HHmmss", Locale.ENGLISH);

    public static Date makeDate(int year, int month, int day) {
        return Dates.makeDate(year, month, day, Calendar.getInstance(TimeZone.getTimeZone(DEFAULT_TIME_ZONE)));
    }

    public static long seconds(double num) {
        return (long)(num * 1000.0);
    }

    public static long minutes(double num) {
        return (long)(num * 60.0 * 1000.0);
    }

    public static long hours(double num) {
        return (long)(num * 60.0 * 60.0 * 1000.0);
    }

    public static long days(double num) {
        return (long)(num * 24.0 * 60.0 * 60.0 * 1000.0);
    }

    public static Date after(Date date, long time) {
        return new Date(date.getTime() + time);
    }

    public static Date before(Date date, long time) {
        return new Date(date.getTime() - time);
    }

    public static Date afterNow(long time) {
        return new Date(System.currentTimeMillis() + time);
    }

    public static Date beforeNow(long time) {
        return new Date(System.currentTimeMillis() - time);
    }

    public static Date makeDate(int year, int month, int day, Calendar calendar) {
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date now() {
        return new Date();
    }

    public static Date today() {
        return Dates.truncateTime(new Date());
    }

    public static Date tomorrow() {
        return Dates.truncateTime(Dates.daysAfterNow(1));
    }

    public static Date yesterday() {
        return Dates.truncateTime(Dates.daysBeforeNow(1));
    }

    public static Date after(Date date) {
        return Dates.after(date, 1L);
    }

    public static Date before(Date date) {
        return Dates.before(date, 1L);
    }

    public static Date makeDate(int year, int month, int day, int hour, int minute, int second, String timeZone) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTime();
    }

    public static boolean isBeforeWithError(Date before, Date after, long allowedError) {
        long afterTime;
        long beforeTime = before.getTime();
        return beforeTime < (afterTime = after.getTime()) - allowedError;
    }

    public static Date daysBeforeNow(int days) {
        return Dates.daysBefore(Dates.now(), days);
    }

    public static Date daysAfterNow(int days) {
        return Dates.daysAfter(Dates.now(), days);
    }

    public static Date daysBefore(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -days);
        return c.getTime();
    }

    public static Date daysAfter(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date truncateTime(Date dateAndTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateAndTime);
        Dates.truncateCalendar(calendar);
        return calendar.getTime();
    }

    public static void truncateCalendar(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void truncateCalendarToEndOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    public static boolean isDayChanged(@NotNull Date date1, @NotNull Date date2) {
        if (date1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date1", "jetbrains/buildServer/util/Dates", "isDayChanged"));
        }
        if (date2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date2", "jetbrains/buildServer/util/Dates", "isDayChanged"));
        }
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        return !Dates.isSameDay(cal1, cal2);
    }

    public static String formatInterval(Date from, Date to, @NotNull TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tz", "jetbrains/buildServer/util/Dates", "formatInterval"));
        }
        if (from == null) {
            throw new NullPointerException("'From' date cannot be null");
        }
        if (to == null) {
            return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - ???";
        }
        if (Dates.isDayChanged(from, to)) {
            return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - " + Dates.formatDate(to, "dd MMM HH:mm", tz);
        }
        return Dates.formatDate(from, "dd MMM HH:mm", tz) + " - " + Dates.formatDate(to, "HH:mm", tz);
    }

    public static String formatDate(Date date, String format) {
        return Dates.formatDate(date, format, TimeZone.getDefault());
    }

    @NotNull
    public static String formatDate(@NotNull Date date, @NotNull String pattern, @NotNull TimeZone tz) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "jetbrains/buildServer/util/Dates", "formatDate"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/Dates", "formatDate"));
        }
        if (tz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tz", "jetbrains/buildServer/util/Dates", "formatDate"));
        }
        SimpleDateFormat df = new SimpleDateFormat(pattern, Locale.ENGLISH);
        df.setTimeZone(tz);
        String string = df.format(date);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Dates", "formatDate"));
        }
        return string;
    }

    public static String convertDateToFormalString(Date date) {
        return date != null ? formalDateFormatter.format(date) : "";
    }

    public static String convertTimeToFormalString(Date time) {
        return time != null ? formalTimeFormatter.format(time) : "";
    }

    public static boolean isSameDay(@NotNull Calendar cal1, @NotNull Calendar cal2) {
        if (cal1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal1", "jetbrains/buildServer/util/Dates", "isSameDay"));
        }
        if (cal2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal2", "jetbrains/buildServer/util/Dates", "isSameDay"));
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static int daysBetween(@NotNull Date startDate, @NotNull Date endDate) {
        if (startDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startDate", "jetbrains/buildServer/util/Dates", "daysBetween"));
        }
        if (endDate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endDate", "jetbrains/buildServer/util/Dates", "daysBetween"));
        }
        Calendar end = Calendar.getInstance();
        end.setTime(Dates.truncateTime(endDate));
        Calendar start = Calendar.getInstance();
        start.setTime(Dates.truncateTime(startDate));
        if (start.equals(end)) {
            return 0;
        }
        if (start.after(end)) {
            throw new IllegalArgumentException("Start date cannot be after the end date");
        }
        int days = 0;
        do {
            start.add(5, 1);
            ++days;
        } while (!start.equals(end));
        return days;
    }

    @NotNull
    public static Date toStandardDate(@NotNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "date", "jetbrains/buildServer/util/Dates", "toStandardDate"));
        }
        Date date2 = new Date(date.getTime());
        if (date2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/Dates", "toStandardDate"));
        }
        return date2;
    }

    public static TimeZone[] getSortedTimeZones() {
        TimeZone[] result = Dates.getFilteredTimeZones();
        final long currentTime = System.currentTimeMillis();
        Comparator<TimeZone> c = new Comparator<TimeZone>(){

            @Override
            public int compare(TimeZone o1, TimeZone o2) {
                return o1.getOffset(currentTime) - o2.getOffset(currentTime);
            }
        };
        Arrays.sort(result, c);
        return result;
    }

    private static TimeZone[] getFilteredTimeZones() {
        String[] ids = TimeZone.getAvailableIDs();
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>(ids.length);
        TimeZone serverTZ = TimeZone.getDefault();
        boolean added = false;
        for (String id : ids) {
            if (!id.contains("/") || id.contains("GMT") || id.indexOf(47) != id.lastIndexOf(47) || id.contains("SystemV")) continue;
            TimeZone timeZone = TimeZone.getTimeZone(id);
            if (serverTZ.equals(timeZone)) {
                added = true;
            }
            zones.add(timeZone);
        }
        if (!added) {
            zones.add(serverTZ);
        }
        return zones.toArray(new TimeZone[zones.size()]);
    }

    public static String formatTimeZoneLong(@NotNull TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tz", "jetbrains/buildServer/util/Dates", "formatTimeZoneLong"));
        }
        return Dates.formatTimeZoneID(tz) + " (" + Dates.formatTimeZoneUTCOffset(tz) + ')';
    }

    public static String formatTimeZoneID(@NotNull TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tz", "jetbrains/buildServer/util/Dates", "formatTimeZoneID"));
        }
        return tz.getDisplayName(false, 0) + ' ' + tz.getID().replace('_', ' ');
    }

    public static String formatTimeZoneUTCOffset() {
        return Dates.formatTimeZoneUTCOffset(TimeZone.getDefault());
    }

    public static String formatTimeZoneUTCOffset(@NotNull TimeZone tz) {
        if (tz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tz", "jetbrains/buildServer/util/Dates", "formatTimeZoneUTCOffset"));
        }
        int currentOffset = tz.getOffset(System.currentTimeMillis());
        int low = Math.abs(currentOffset / 60000 % 60);
        int high = Math.abs(currentOffset / 3600000);
        return "UTC" + (currentOffset >= 0 ? (char)'+' : '-') + high + (low > 0 ? ":" + (low < 10 ? "0" + low : Integer.valueOf(low)) : "");
    }

    public static boolean isValidTimeZoneID(@NotNull String tzID) {
        if (tzID == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tzID", "jetbrains/buildServer/util/Dates", "isValidTimeZoneID"));
        }
        for (String tz : TimeZone.getAvailableIDs()) {
            if (!tz.equals(tzID)) continue;
            return true;
        }
        return false;
    }

    public static Calendar translateFromTimeZone(Calendar initDate, TimeZone timeZone) {
        if (timeZone == null) {
            return initDate;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(initDate.getTimeInMillis());
        c.get(10);
        return c;
    }

    public static Calendar transletoToTimeZone(Calendar initDate, TimeZone timeZone) {
        if (timeZone == null) {
            return initDate;
        }
        Calendar c = Calendar.getInstance(timeZone);
        c.setTimeInMillis(initDate.getTimeInMillis());
        c.get(10);
        return c;
    }

    public static Calendar copy(Calendar to, Calendar from) {
        to.set(from.get(1), from.get(2), from.get(5), from.get(11), from.get(12), from.get(13));
        to.set(14, from.get(14));
        return to;
    }
}

