/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.Predicate;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TCStreamUtil;
import jetbrains.buildServer.util.ThreadUtil;
import jetbrains.buildServer.util.XmlUtil;
import org.apache.commons.io.FileSystemUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil
extends com.intellij.openapi.util.io.FileUtil {
    private static final Logger LOG;
    private static final FileFilter ACCEPT_ALL_FILES_FILTER;
    private static final String FIX_DIRECTORY_NAME_PATTERN = "[^A-Za-z0-9_ &#.@$%\\[\\]\\(\\){}\\-+=]";
    private static final String BAD_DIRECTORY_NAME_PATTERN = ".*[^A-Za-z0-9_ &#.@$%\\[\\]\\(\\){}\\-+=].*";
    private static final Comparator<File> FILE_COMPARATOR;
    private static final File[] ourEmptyFilesArray;
    private static final Method IO_FILE_SET_EXECUTABLE_METHOD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> readFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "readFile"));
        }
        FileInputStream is = new FileInputStream(file);
        String text = StreamUtil.readText((InputStream)is);
        List<String> list = Arrays.asList(text.split("\\r?\\n"));
        List<String> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "readFile"));
        }
        return list2;
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "readText"));
        }
        FileInputStream is = new FileInputStream(file);
        try {
            String string = StreamUtil.readText((InputStream)is);
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(@NotNull File file, @NotNull String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "readText"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "jetbrains/buildServer/util/FileUtil", "readText"));
        }
        FileInputStream is = new FileInputStream(file);
        try {
            String string = StreamUtil.readText((InputStream)is, (String)encoding);
            return string;
        }
        finally {
            is.close();
        }
    }

    public static void writeFile(@NotNull File file, @NotNull String text) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "writeFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/FileUtil", "writeFile"));
        }
        try {
            FileUtil.writeFileAndReportErrors(file, text);
        }
        catch (IOException e) {
            LOG.warn(e.toString());
            LOG.debug(e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileAndReportErrors(@NotNull File file, @NotNull String text) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "writeFileAndReportErrors"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/FileUtil", "writeFileAndReportErrors"));
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(text);
        }
        catch (Throwable throwable) {
            FileUtil.close(fileWriter);
            throw throwable;
        }
        FileUtil.close(fileWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(@NotNull File file, @NotNull String text, @NotNull String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "writeFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/util/FileUtil", "writeFile"));
        }
        if (encoding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "jetbrains/buildServer/util/FileUtil", "writeFile"));
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            writer.write(text);
        }
        catch (Throwable throwable) {
            FileUtil.close(writer);
            throw throwable;
        }
        FileUtil.close(writer);
    }

    public static void readXmlFile(@NotNull File file, @NotNull Processor p) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "readXmlFile"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/util/FileUtil", "readXmlFile"));
        }
        if (file.exists()) {
            try {
                FileUtil.getProcessedDocument(file, p);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private static Document getProcessedDocument(@NotNull File file, @NotNull Processor p) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "getProcessedDocument"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/util/FileUtil", "getProcessedDocument"));
        }
        Document document = FileUtil.parseDocument(file).getDocument();
        p.process(document.getRootElement());
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getProcessedDocument"));
        }
        return document2;
    }

    @NotNull
    private static SAXBuilder getBuilder(boolean validate) {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        builder.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        builder.setEntityResolver((EntityResolver)new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
                String dtdFileName = new File(systemId).getName();
                InputStream dtdStream = this.getClass().getClassLoader().getResourceAsStream(dtdFileName);
                if (dtdStream != null) {
                    return new InputSource(dtdStream);
                }
                return super.resolveEntity(publicId, systemId);
            }
        });
        SAXBuilder sAXBuilder = builder;
        if (sAXBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getBuilder"));
        }
        return sAXBuilder;
    }

    public static Element parseDocument(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "parseDocument"));
        }
        return FileUtil.parseDocument(file, false);
    }

    public static Element parseDocument(@NotNull File file, boolean validate) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "parseDocument"));
        }
        return FileUtil.getBuilder(validate).build(file).getRootElement();
    }

    public static Element parseDocument(@NotNull InputStream input, boolean validate) throws JDOMException, IOException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/util/FileUtil", "parseDocument"));
        }
        return FileUtil.getBuilder(validate).build(input).getRootElement();
    }

    public static Element parseDocument(@NotNull Reader input, boolean validate) throws JDOMException, IOException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "jetbrains/buildServer/util/FileUtil", "parseDocument"));
        }
        return FileUtil.getBuilder(validate).build(input).getRootElement();
    }

    public static void processXmlFile(@NotNull File file, @NotNull Processor p) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "processXmlFile"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "jetbrains/buildServer/util/FileUtil", "processXmlFile"));
        }
        if (file.exists()) {
            try {
                FileUtil.saveDocument(FileUtil.getProcessedDocument(file, p), file);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(@NotNull Document document, @NotNull File file) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "jetbrains/buildServer/util/FileUtil", "saveDocument"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "saveDocument"));
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XmlUtil.saveDocument(document, fos);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getFilesSignature(@NotNull Collection<File> _files) {
        if (_files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_files", "jetbrains/buildServer/util/FileUtil", "getFilesSignature"));
        }
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(_files);
        Collections.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int hash = 0;
        byte[] bytes = new byte[8192];
        for (File file : files) {
            if (file.isDirectory()) continue;
            try {
                hash = 31 * hash + 1;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    int count;
                    do {
                        count = ((InputStream)is).read(bytes, 0, bytes.length);
                        for (int i = 0; i < count; ++i) {
                            hash = 31 * hash + bytes[i];
                        }
                    } while (count >= 0);
                }
                finally {
                    FileUtil.close(is);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(file.getAbsolutePath() + ": " + hash);
        }
        String s = Integer.toHexString(hash);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature of the files  : " + s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getFilesSignature"));
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(String prefix, String suffix, File in) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix, in);
        tempFile.delete();
        tempFile.mkdir();
        File file = tempFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File getFileInSameDir(@NotNull File origFile, String neededFileName) {
        if (origFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origFile", "jetbrains/buildServer/util/FileUtil", "getFileInSameDir"));
        }
        File parent = origFile.getParentFile();
        File file = parent != null ? new File(parent, neededFileName) : new File(neededFileName);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getFileInSameDir"));
        }
        return file;
    }

    public static void renameAndReportErrors(@NotNull File oldName, @NotNull File newName) throws IOException, SecurityException {
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "jetbrains/buildServer/util/FileUtil", "renameAndReportErrors"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "jetbrains/buildServer/util/FileUtil", "renameAndReportErrors"));
        }
        boolean renamedSuccessfully = oldName.renameTo(newName);
        if (!renamedSuccessfully) {
            throw new IOException("Failed to rename \"" + oldName + "\" to \"" + newName + "\". The File.renameTo() returned false.");
        }
    }

    public static boolean sameButDifferInCase(@NotNull File file1, @NotNull File file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "jetbrains/buildServer/util/FileUtil", "sameButDifferInCase"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "jetbrains/buildServer/util/FileUtil", "sameButDifferInCase"));
        }
        if (SystemInfo.isFileSystemCaseSensitive) {
            return false;
        }
        File dir1 = file1.getParentFile();
        File dir2 = file2.getParentFile();
        String name1 = file1.getName();
        String name2 = file2.getName();
        return dir1.equals(dir2) && StringUtil.differCaseOnly(name1, name2);
    }

    @NotNull
    public static File renameFileNameOnly(@NotNull File file, @NotNull String newName) throws IOException, SecurityException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "renameFileNameOnly"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "jetbrains/buildServer/util/FileUtil", "renameFileNameOnly"));
        }
        if (!file.exists()) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the source file doesn't exist.");
        }
        File dir = file.getParentFile();
        File newFile = new File(dir, newName);
        if (newName.contains("/") || newName.contains("\\")) {
            newFile = newFile.getCanonicalFile();
        }
        if (newFile.exists()) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the destination file already exists.");
        }
        boolean renamed = file.renameTo(newFile);
        if (!renamed) {
            throw new IOException("cannot rename \"" + file + "\" to \"" + newName + "\": the method File.rename() returned false.");
        }
        File file2 = newFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "renameFileNameOnly"));
        }
        return file2;
    }

    @NotNull
    public static File resolvePath(@NotNull File baseDir, @NotNull String path) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "jetbrains/buildServer/util/FileUtil", "resolvePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/FileUtil", "resolvePath"));
        }
        File pathFile = new File(path);
        if (pathFile.isAbsolute()) {
            File file = pathFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "resolvePath"));
            }
            return file;
        }
        File rawFile = new File(baseDir, path);
        if (baseDir.getPath().startsWith("\\\\")) {
            File file = rawFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "resolvePath"));
            }
            return file;
        }
        File file = new File(rawFile.toURI().normalize().getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "resolvePath"));
        }
        return file;
    }

    public static void copyResource(@NotNull String resourceName, @NotNull File outputFile) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "jetbrains/buildServer/util/FileUtil", "copyResource"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "jetbrains/buildServer/util/FileUtil", "copyResource"));
        }
        FileUtil.copyResource(FileUtil.class, resourceName, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/util/FileUtil", "copyResource"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "jetbrains/buildServer/util/FileUtil", "copyResource"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "jetbrains/buildServer/util/FileUtil", "copyResource"));
        }
        InputStream asStream = null;
        FileOutputStream outputStream = null;
        try {
            asStream = clazz.getResourceAsStream(resourceName);
            if (asStream != null) {
                outputStream = new FileOutputStream(outputFile);
                StreamUtil.copyStreamContent((InputStream)asStream, (OutputStream)outputStream);
            } else {
                LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", resource not found");
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to copy resource " + resourceName + " from class " + clazz.getName() + ", due to the error: " + t.getMessage());
        }
        finally {
            if (asStream != null) {
                try {
                    asStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    public static void copyResourceIfNotExists(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/util/FileUtil", "copyResourceIfNotExists"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "jetbrains/buildServer/util/FileUtil", "copyResourceIfNotExists"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "jetbrains/buildServer/util/FileUtil", "copyResourceIfNotExists"));
        }
        if (!outputFile.exists()) {
            FileUtil.copyResource(clazz, resourceName, outputFile);
        }
    }

    public static void copyResourceWithDist(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull File outputFile) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/util/FileUtil", "copyResourceWithDist"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "jetbrains/buildServer/util/FileUtil", "copyResourceWithDist"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "jetbrains/buildServer/util/FileUtil", "copyResourceWithDist"));
        }
        try {
            File distFile = new File(outputFile.getParent(), outputFile.getName() + ".dist");
            if (!outputFile.exists() || !distFile.exists() || FileUtil.readText(outputFile).equals(FileUtil.readText(distFile))) {
                FileUtil.copyResource(clazz, resourceName, outputFile);
            }
            FileUtil.copyResource(clazz, resourceName, distFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readResourceAsString(@NotNull Class<?> clazz, @NotNull String resourceName, @NotNull Charset charset) throws IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/util/FileUtil", "readResourceAsString"));
        }
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "jetbrains/buildServer/util/FileUtil", "readResourceAsString"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "jetbrains/buildServer/util/FileUtil", "readResourceAsString"));
        }
        InputStream rcStream = clazz.getResourceAsStream(resourceName);
        if (rcStream == null) {
            return null;
        }
        try {
            String string;
            InputStreamReader rdr = new InputStreamReader(rcStream, charset);
            try {
                string = StreamUtil.readTextFrom((Reader)rdr);
            }
            catch (Throwable throwable) {
                ((Reader)rdr).close();
                throw throwable;
            }
            ((Reader)rdr).close();
            return string;
        }
        finally {
            rcStream.close();
        }
    }

    public static void copyStreams(InputStream is, OutputStream os) throws IOException {
        TCStreamUtil.writeBinary(is, os);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFilePart(@NotNull File sourceFile, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        void destination;
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "jetbrains/buildServer/util/FileUtil", "copyFilePart"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "length", "jetbrains/buildServer/util/FileUtil", "copyFilePart"));
        }
        FileUtil.copyStreamRangeAndClose(new BufferedInputStream(new FileInputStream(sourceFile)), offset, length, (OutputStream)destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void copyStreamRangeAndClose(@NotNull InputStream source, long offset, long length, @NotNull OutputStream outputStream) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/FileUtil", "copyStreamRangeAndClose"));
        }
        if (outputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "length", "jetbrains/buildServer/util/FileUtil", "copyStreamRangeAndClose"));
        }
        try {
            void destination;
            TCStreamUtil.skip(source, offset);
            TCStreamUtil.writeBinary(source, length, (OutputStream)destination);
        }
        finally {
            FileUtil.close(source);
        }
    }

    public static void close(@Nullable Closeable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(@Nullable ZipFile e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable ... toClose) {
        if (toClose == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toClose", "jetbrains/buildServer/util/FileUtil", "closeAll"));
        }
        for (Closeable e : toClose) {
            if (e == null) continue;
            try {
                e.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    @NotNull
    public static List<File> getSubDirectories(@NotNull File root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "jetbrains/buildServer/util/FileUtil", "getSubDirectories"));
        }
        File[] files = root.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        List<Object> list = files == null ? Collections.emptyList() : Arrays.asList(files);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getSubDirectories"));
        }
        return list;
    }

    @NotNull
    public static File createDir(@NotNull File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/buildServer/util/FileUtil", "createDir"));
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getAbsolutePath());
        }
        File file = dir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "createDir"));
        }
        return file;
    }

    public static File createEmptyDir(@NotNull File dir) throws IOException {
        File[] files;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/buildServer/util/FileUtil", "createEmptyDir"));
        }
        if (dir.exists() && (files = dir.listFiles()) != null && files.length > 0) {
            FileUtil.delete(dir);
        }
        FileUtil.createDir(dir);
        return dir;
    }

    public static long getTotalDirectorySize(@Nullable File dir) {
        return FileUtil.getTotalDirectorySize(dir, false);
    }

    public static long getTotalDirectorySize(@Nullable File dir, boolean recursively) {
        if (dir == null) {
            return 0L;
        }
        if (recursively) {
            final long[] size = new long[]{0L};
            FileUtil.findFiles(new FileFilter(){

                public boolean accept(File f) {
                    size[0] = size[0] + f.length();
                    return true;
                }
            }, dir);
            return size[0];
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return 0L;
        }
        long size = 0L;
        for (File file : files) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    public static void deleteIfEmpty(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/buildServer/util/FileUtil", "deleteIfEmpty"));
        }
        if (dir.exists() && FileUtil.isEmptyDir(dir)) {
            FileUtil.delete(dir);
        }
    }

    public static Set<File> delete(@NotNull File fileOrDirectory, int numAttempts) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDirectory", "jetbrains/buildServer/util/FileUtil", "delete"));
        }
        return FileUtil.delete(fileOrDirectory, ACCEPT_ALL_FILES_FILTER, numAttempts);
    }

    public static Set<File> delete(@NotNull File fileOrDirectory, @NotNull FileFilter fileFilter, int numAttempts) {
        if (fileOrDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDirectory", "jetbrains/buildServer/util/FileUtil", "delete"));
        }
        if (fileFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileFilter", "jetbrains/buildServer/util/FileUtil", "delete"));
        }
        HashSet<File> visited = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>();
        LinkedList<File> toRemove = new LinkedList<File>();
        toRemove.add(fileOrDirectory);
        while (!toRemove.isEmpty()) {
            File[] files;
            File next = (File)toRemove.peek();
            boolean acceptedByFilter = fileFilter.accept(next);
            if (visited.add(next) && acceptedByFilter && (files = next.listFiles()) != null) {
                boolean hasSomethingToRemove = false;
                for (File f : files) {
                    if (visited.contains(f)) continue;
                    toRemove.addFirst(f);
                    hasSomethingToRemove = true;
                }
                if (files.length > 0 && hasSomethingToRemove) continue;
                if (files.length > 0) {
                    toRemove.remove(next);
                    continue;
                }
            }
            boolean fileRemoved = false;
            if (acceptedByFilter) {
                fileRemoved = false;
                for (int i = 0; i < numAttempts; ++i) {
                    if (next.delete() || !next.exists()) {
                        removed.add(next);
                        fileRemoved = true;
                        break;
                    }
                    ThreadUtil.sleep(10L);
                }
            }
            toRemove.remove(next);
            if (fileRemoved) continue;
            for (File parentFile = next.getParentFile(); parentFile != null && toRemove.remove(parentFile); parentFile = parentFile.getParentFile()) {
            }
        }
        return removed;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "delete"));
        }
        return FileUtil.delete(file, ACCEPT_ALL_FILES_FILTER, 10).contains(file);
    }

    public static boolean isEmptyDir(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/buildServer/util/FileUtil", "isEmptyDir"));
        }
        File[] files = dir.listFiles();
        if (files == null && dir.isDirectory()) {
            return false;
        }
        return files == null || files.length == 0;
    }

    public static boolean isReadonly(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "isReadonly"));
        }
        if (file.isDirectory()) {
            return false;
        }
        return !file.canWrite();
    }

    @NotNull
    public static String fixDirectoryName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/FileUtil", "fixDirectoryName"));
        }
        String string = name.replaceAll(FIX_DIRECTORY_NAME_PATTERN, "_");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "fixDirectoryName"));
        }
        return string;
    }

    public static boolean isBadDirectoryName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/FileUtil", "isBadDirectoryName"));
        }
        return name.matches(BAD_DIRECTORY_NAME_PATTERN);
    }

    @NotNull
    public static String normalizeSeparator(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "jetbrains/buildServer/util/FileUtil", "normalizeSeparator"));
        }
        StringBuilder result = new StringBuilder(filePath.length());
        for (int i = 0; i < filePath.length(); ++i) {
            char c = filePath.charAt(i);
            result.append(c == '/' || c == '\\' ? File.separatorChar : c);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "normalizeSeparator"));
        }
        return string;
    }

    @NotNull
    public static String normalizeRelativePath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/FileUtil", "normalizeRelativePath"));
        }
        String string = new PathNormalizer(path).invoke();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "normalizeRelativePath"));
        }
        return string;
    }

    public static void sortFiles(@NotNull File[] files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "jetbrains/buildServer/util/FileUtil", "sortFiles"));
        }
        Arrays.sort(files, FILE_COMPARATOR);
    }

    @NotNull
    public static String getCommonParent(@NotNull String firstUrl, @NotNull String secondUrl) {
        char c2;
        char c1;
        int i;
        if (firstUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstUrl", "jetbrains/buildServer/util/FileUtil", "getCommonParent"));
        }
        if (secondUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondUrl", "jetbrains/buildServer/util/FileUtil", "getCommonParent"));
        }
        StringBuffer result = new StringBuffer();
        StringBuffer nextPathElem = new StringBuffer();
        boolean addSeparator = false;
        for (i = 0; i < firstUrl.length() && i < secondUrl.length() && (c1 = firstUrl.charAt(i)) == (c2 = secondUrl.charAt(i)); ++i) {
            if (FileUtil.isFileSeparator(c1) || FileUtil.isFileSeparator(c2)) {
                if (addSeparator) {
                    result.append("/");
                }
                if (nextPathElem.length() > 0) {
                    result.append(nextPathElem.toString());
                    nextPathElem = new StringBuffer();
                    addSeparator = true;
                    continue;
                }
                if (addSeparator) {
                    result.append("/");
                    addSeparator = false;
                    continue;
                }
                addSeparator = true;
                continue;
            }
            nextPathElem.append(c1);
        }
        if ((i == firstUrl.length() || i == secondUrl.length()) && nextPathElem.length() > 0) {
            if (result.length() > 0) {
                result.append("/");
            }
            result.append(nextPathElem.toString());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getCommonParent"));
        }
        return string;
    }

    public static boolean isFileSeparator(char c1) {
        return c1 == '\\' || c1 == '/';
    }

    @NotNull
    public static File getCanonicalFile(@NotNull File file) {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "getCanonicalFile"));
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException e) {
            File file3 = file.getAbsoluteFile();
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getCanonicalFile"));
            }
            return file3;
        }
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getCanonicalFile"));
        }
        return file2;
    }

    public static void checkTmpDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tmpDir.isDirectory() && !tmpDir.mkdirs()) {
            throw new IllegalStateException("\n\n\nUnable to access temp directory " + tmpDir.getAbsolutePath() + "\n\n\n");
        }
    }

    @Nullable
    public static File findFile(@NotNull FileFilter filter, File ... directories) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/FileUtil", "findFile"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "jetbrains/buildServer/util/FileUtil", "findFile"));
        }
        Collection<File> found = FileUtil.doFindFiles(filter, directories, true);
        if (found.size() == 0) {
            return null;
        }
        return found.iterator().next();
    }

    @NotNull
    public static Collection<File> findFiles(@NotNull FileFilter filter, File ... directories) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/FileUtil", "findFiles"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "jetbrains/buildServer/util/FileUtil", "findFiles"));
        }
        Collection<File> collection = FileUtil.doFindFiles(filter, directories, false);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "findFiles"));
        }
        return collection;
    }

    @NotNull
    private static Collection<File> doFindFiles(@NotNull FileFilter filter, @NotNull File[] directories, boolean stopOnFirstMatch) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/FileUtil", "doFindFiles"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "jetbrains/buildServer/util/FileUtil", "doFindFiles"));
        }
        HashSet<File> found = new HashSet<File>();
        HashSet<File> processed = new HashSet<File>();
        LinkedList<File> directoriesToSearch = new LinkedList<File>();
        for (File dir : directories) {
            File absDir = dir.getAbsoluteFile();
            if (!processed.add(absDir)) continue;
            directoriesToSearch.offer(absDir);
        }
        while (!directoriesToSearch.isEmpty()) {
            File nextDir = (File)directoriesToSearch.poll();
            File[] files = nextDir.listFiles();
            if (files == null || files.length == 0) continue;
            for (File f : files) {
                File absFile = f.getAbsoluteFile();
                boolean isDir = absFile.isDirectory();
                if (isDir && processed.add(absFile)) {
                    directoriesToSearch.offer(f);
                }
                if (isDir || !filter.accept(absFile)) continue;
                if (stopOnFirstMatch) {
                    Set<File> set = Collections.singleton(absFile);
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "doFindFiles"));
                    }
                    return set;
                }
                found.add(absFile);
            }
        }
        HashSet<File> hashSet = found;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "doFindFiles"));
        }
        return hashSet;
    }

    public static <C extends Collection<String>> C listFilesRecursively(@NotNull File dir, @NotNull String prefix, boolean includeDirs, int depthLimit, @Nullable Predicate<File> predicate, @NotNull C collection) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "jetbrains/buildServer/util/FileUtil", "listFilesRecursively"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "jetbrains/buildServer/util/FileUtil", "listFilesRecursively"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/FileUtil", "listFilesRecursively"));
        }
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                String name;
                if (child == null || (name = child.getName()).equals(".") || name.equals("..") || predicate != null && !predicate.apply(child)) continue;
                String entry = prefix + name;
                if (child.isDirectory()) {
                    if (includeDirs) {
                        collection.add((String)entry);
                    }
                    if (depthLimit <= 0) continue;
                    FileUtil.listFilesRecursively(child, entry + '/', includeDirs, depthLimit - 1, predicate, collection);
                    continue;
                }
                collection.add((String)(prefix + name));
            }
        }
        return collection;
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory, @NotNull FilenameFilter filter) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "jetbrains/buildServer/util/FileUtil", "listFiles"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/FileUtil", "listFiles"));
        }
        File[] result = directory.listFiles(filter);
        File[] fileArray = result != null ? result : ourEmptyFilesArray;
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "listFiles"));
        }
        return fileArray;
    }

    @Nullable
    public static Long getFreeSpace(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "getFreeSpace"));
        }
        Method method = null;
        try {
            method = File.class.getMethod("getUsableSpace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                return (Long)method.invoke((Object)file, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Failed to compute free space using Java API for directory: " + file + ", error: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            return FileSystemUtils.freeSpaceKb((String)file.getPath()) * 1024L;
        }
        catch (Exception e) {
            LOG.warn("Failed to compute free space using command line utilities for directory: " + file + ", error: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File from, @NotNull File to) throws IOException {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "jetbrains/buildServer/util/FileUtil", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "jetbrains/buildServer/util/FileUtil", "copy"));
        }
        if (FileUtil.areTheSame(from, to)) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(from), 20480);
        if (!to.exists()) {
            File parentfile = to.getParentFile();
            if (parentfile != null) {
                parentfile.mkdirs();
            }
            to.createNewFile();
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(to), 20480);
        try {
            TCStreamUtil.writeBinary(is, os);
        }
        finally {
            FileUtil.close(is);
            FileUtil.close(os);
        }
    }

    public static boolean areTheSame(@Nullable File file1, @Nullable File file2) throws IOException {
        if (file1 == null && file2 == null) {
            return true;
        }
        if (file1 == null || file2 == null) {
            return false;
        }
        File x1 = file1.getCanonicalFile();
        File x2 = file2.getCanonicalFile();
        return x1.equals(x2);
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern) {
        if (antPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "antPattern", "jetbrains/buildServer/util/FileUtil", "convertAntToRegexp"));
        }
        String string = FileUtil.convertAntToRegexp(antPattern, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "convertAntToRegexp"));
        }
        return string;
    }

    @NotNull
    public static String convertAntToRegexp(@NotNull String antPattern, boolean ignoreStartingSlash) {
        boolean isTrailingSlash;
        int start;
        if (antPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "antPattern", "jetbrains/buildServer/util/FileUtil", "convertAntToRegexp"));
        }
        StringBuilder builder = new StringBuilder(antPattern.length());
        int asteriskCount = 0;
        boolean recursive = true;
        for (int idx = start = ignoreStartingSlash && (antPattern.startsWith("/") || antPattern.startsWith("\\")) ? 1 : 0; idx < antPattern.length(); ++idx) {
            char ch = antPattern.charAt(idx);
            if (ch == '*') {
                ++asteriskCount;
                continue;
            }
            boolean foundRecursivePattern = recursive && asteriskCount == 2 && (ch == '/' || ch == '\\');
            boolean asterisksFound = asteriskCount > 0;
            asteriskCount = 0;
            boolean bl = recursive = ch == '/' || ch == '\\';
            if (foundRecursivePattern) {
                builder.append("(?:[^/]+/)*?");
                continue;
            }
            if (asterisksFound) {
                builder.append("[^/]*?");
            }
            if (ch == '[' || ch == ']' || ch == '^' || ch == '$' || ch == '.' || ch == '{' || ch == '}' || ch == '+' || ch == '|' || ch == '(' || ch == ')') {
                builder.append('\\').append(ch);
                continue;
            }
            if (ch == '?') {
                builder.append("[^/]{1}");
                continue;
            }
            if (ch == '\\') {
                builder.append('/');
                continue;
            }
            builder.append(ch);
        }
        boolean bl = isTrailingSlash = builder.length() > 0 && builder.charAt(builder.length() - 1) == '/';
        if (asteriskCount == 0 && isTrailingSlash || recursive && asteriskCount == 2) {
            if (isTrailingSlash) {
                builder.setLength(builder.length() - 1);
            }
            if (builder.length() == 0) {
                builder.append(".*");
            } else {
                builder.append("(?:$|/.+)");
            }
        } else if (asteriskCount > 0) {
            builder.append("[^/]*?");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "convertAntToRegexp"));
        }
        return string;
    }

    @NotNull
    public static String getExtension(@NotNull String fileNameWithDirectory) {
        if (fileNameWithDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileNameWithDirectory", "jetbrains/buildServer/util/FileUtil", "getExtension"));
        }
        int dotIdx = fileNameWithDirectory.lastIndexOf(".");
        int pathSeparatorIdx = Math.max(fileNameWithDirectory.lastIndexOf(47), fileNameWithDirectory.lastIndexOf(92));
        if (dotIdx != -1 && pathSeparatorIdx < dotIdx) {
            String string = fileNameWithDirectory.substring(dotIdx + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getExtension"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getExtension"));
        }
        return "";
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "getNameWithoutExtension"));
        }
        String string = FileUtil.getNameWithoutExtension(file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getNameWithoutExtension"));
        }
        return string;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/FileUtil", "getNameWithoutExtension"));
        }
        String ext = FileUtil.getExtension(name);
        String string = ext.length() > 0 ? name.substring(0, name.length() - ext.length() - 1) : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/FileUtil", "getNameWithoutExtension"));
        }
        return string;
    }

    public static void setExectuableAttribute(String path, boolean executableFlag) throws IOException {
        if (IO_FILE_SET_EXECUTABLE_METHOD != null) {
            try {
                IO_FILE_SET_EXECUTABLE_METHOD.invoke((Object)new File(path), executableFlag);
                return;
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!SystemInfo.isWindows) {
            Process process = Runtime.getRuntime().exec(new String[]{"chmod", executableFlag ? "u+x" : "u-x", path});
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean checkContentEqual(@NotNull File file1, @NotNull File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        if (ancestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "jetbrains/buildServer/util/FileUtil", "isAncestor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "isAncestor"));
        }
        try {
            return com.intellij.openapi.util.io.FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowAsRuntimeException(e);
            return false;
        }
    }

    public static void copy(@NotNull InputStream is, @NotNull OutputStream os) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "jetbrains/buildServer/util/FileUtil", "copy"));
        }
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "jetbrains/buildServer/util/FileUtil", "copy"));
        }
        FileUtil.copyStreams(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinaryFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/util/FileUtil", "isBinaryFile"));
        }
        FileInputStream input = new FileInputStream(file);
        try {
            byte[] buffer = new byte[1024];
            int size = input.read(buffer);
            if (size <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = FileUtil.isBinaryData(buffer, size);
            return bl;
        }
        finally {
            input.close();
        }
    }

    public static boolean isBinaryData(byte[] data, int size) {
        return !FileUtil.isTextData(data, size);
    }

    public static boolean isTextData(byte[] data, int size) {
        for (int i = 0; i < Math.min(size, data.length); ++i) {
            if (data[i] < 1 || data[i] >= 9) continue;
            return false;
        }
        return true;
    }

    static {
        Method method;
        LOG = Logger.getInstance((String)FileUtil.class.getName());
        ACCEPT_ALL_FILES_FILTER = new FileFilter(){

            public boolean accept(File pathname) {
                return true;
            }
        };
        FILE_COMPARATOR = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.isDirectory() && o2.isFile()) {
                    return -1;
                }
                if (o1.isFile() && o2.isDirectory()) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        ourEmptyFilesArray = new File[0];
        try {
            method = File.class.getDeclaredMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_EXECUTABLE_METHOD = method;
    }

    public static class RegexFileFilter
    implements FileFilter {
        @NotNull
        final Pattern myPattern;

        public RegexFileFilter(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/FileUtil$RegexFileFilter", "<init>"));
            }
            this.myPattern = Pattern.compile(pattern, 2);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isFile() && this.myPattern.matcher(file.getName()).matches();
        }
    }

    private static class PathNormalizer {
        private final String myPath;
        private final List<String> myParts;
        private final StringBuilder myNextPart;

        public PathNormalizer(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/util/FileUtil$PathNormalizer", "<init>"));
            }
            this.myParts = new ArrayList<String>();
            this.myNextPart = new StringBuilder();
            this.myPath = path;
        }

        public String invoke() {
            this.collectParts();
            return this.joinParts();
        }

        private void collectParts() {
            block3: for (int i = 0; i < this.myPath.length(); ++i) {
                char c = this.myPath.charAt(i);
                switch (c) {
                    case '/': 
                    case '\\': {
                        this.processBoundary();
                        continue block3;
                    }
                    default: {
                        this.myNextPart.append(c);
                    }
                }
            }
            this.processBoundary();
        }

        private void processBoundary() {
            if (this.myNextPart.length() > 0) {
                String val = this.myNextPart.toString();
                if ("..".equals(val)) {
                    if (this.myParts.size() > 0 && !"..".equals(this.myParts.get(this.myParts.size() - 1))) {
                        this.removeLast();
                    } else {
                        this.myParts.add(val);
                    }
                } else if (!".".equals(val)) {
                    this.myParts.add(val);
                }
                this.reset();
            }
        }

        private void removeLast() {
            this.myParts.remove(this.myParts.size() - 1);
        }

        private void reset() {
            this.myNextPart.delete(0, this.myNextPart.length());
        }

        private String joinParts() {
            return StringUtil.join("/", this.myParts);
        }
    }

    public static interface Processor {
        public void process(Element var1);
    }
}

