/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.Alarm;
import java.lang.reflect.Field;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.ThreadUtil;
import org.jetbrains.annotations.Nullable;

public class IdeaThreadPoolsShutdown {
    private static final AtomicBoolean myStaticPoolsShutdownScheduled = new AtomicBoolean(false);

    public static void shutdownStaticPools() {
        Runnable run = new Runnable(){

            public void run() {
                ExecutorService alarmPool;
                ExecutorService pool = IdeaThreadPoolsShutdown.getOSProcessHandlerPool();
                if (pool != null) {
                    ThreadUtil.shutdownNowAndWait(pool, "OSProcessHandler pool");
                }
                if ((alarmPool = IdeaThreadPoolsShutdown.getAlarmPool()) != null) {
                    ThreadUtil.shutdownNowAndWait(alarmPool, "Alarm pool");
                }
                ThreadUtil.shutdownNowAndWait(JobScheduler.getScheduler(), "JobScheduler pool");
            }
        };
        if (!LogInitializer.isUnitTest()) {
            run.run();
        } else if (myStaticPoolsShutdownScheduled.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(run));
        }
    }

    @Nullable
    private static ExecutorService getOSProcessHandlerPool() {
        try {
            Class<?>[] innerClasses;
            for (Class<?> c : innerClasses = OSProcessHandler.class.getDeclaredClasses()) {
                Field[] fields;
                if (!"com.intellij.execution.process.OSProcessHandler$ExecutorServiceHolder".equals(c.getName())) continue;
                for (Field f : fields = c.getDeclaredFields()) {
                    if (!"ourThreadExecutorsService".equals(f.getName())) continue;
                    f.setAccessible(true);
                    Object obj = f.get(null);
                    if (obj instanceof ExecutorService) {
                        return (ExecutorService)obj;
                    }
                    return null;
                }
            }
        }
        catch (Throwable e) {
            Loggers.SERVER.warn("Failed to obtain OSProcessHandler pool", e);
        }
        return null;
    }

    @Nullable
    private static ExecutorService getAlarmPool() {
        try {
            Field[] fields;
            for (Field f : fields = Alarm.class.getDeclaredFields()) {
                if (!"ourSharedExecutorService".equals(f.getName())) continue;
                f.setAccessible(true);
                Object obj = f.get(null);
                if (obj instanceof ExecutorService) {
                    return (ExecutorService)obj;
                }
                return null;
            }
        }
        catch (Throwable e) {
            Loggers.SERVER.warn("Failed to obtain Alarm pool", e);
        }
        return null;
    }
}

