/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Calendar;
import org.jetbrains.annotations.NotNull;

public class NamedThreadUtil {
    private static final String tc_prefix = "TC: ";

    @NotNull
    public static ThreadNameCookie updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        ThreadNameCookie threadNameCookie = new ThreadNameCookie().setNewName(newDetails);
        if (threadNameCookie == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil", "updateThreadName"));
        }
        return threadNameCookie;
    }

    public static String getTcThreadPrefix() {
        return tc_prefix + NamedThreadUtil.time_prefix();
    }

    @NotNull
    private static String time_prefix() {
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        int min = c.get(12);
        int sec = c.get(13);
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour).append(':');
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min).append(':');
        if (sec < 10) {
            sb.append('0');
        }
        sb.append(sec).append(' ');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil", "time_prefix"));
        }
        return string;
    }

    public static final class ThreadNameCookie {
        private final Thread myThread = Thread.currentThread();
        private final String myOldMessage;

        private ThreadNameCookie() {
            String message = this.myThread.getName();
            if (message == null) {
                message = "";
            }
            this.myOldMessage = message;
        }

        @NotNull
        public String getOldName() {
            String string = this.myOldMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "getOldName"));
            }
            return string;
        }

        @NotNull
        public ThreadNameCookie setNewName(@NotNull String newDetails) {
            if (newDetails == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "setNewName"));
            }
            String currentName = this.getOldName();
            String namePrefix = NamedThreadUtil.getTcThreadPrefix() + newDetails + "; ";
            if (currentName.startsWith(NamedThreadUtil.tc_prefix)) {
                this.myThread.setName(namePrefix + currentName.substring(NamedThreadUtil.tc_prefix.length()));
            } else {
                this.myThread.setName(namePrefix + currentName);
            }
            ThreadNameCookie threadNameCookie = this;
            if (threadNameCookie == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie", "setNewName"));
            }
            return threadNameCookie;
        }

        public void dispose() {
            this.myThread.setName(this.myOldMessage);
        }
    }
}

