/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchroDictionary<K, V> {
    @NotNull
    private final Function<K, V> myDataProvider;
    @NotNull
    private final ConcurrentHashMap<K, Object> myLocks;
    @NotNull
    private final ConcurrentHashMap<K, V> myObjects;
    @NotNull
    private final ReadWriteLock myGlobalLock;

    public SynchroDictionary(@NotNull Function<K, V> dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "jetbrains/buildServer/util/SynchroDictionary", "<init>"));
        }
        this.myLocks = new ConcurrentHashMap();
        this.myObjects = new ConcurrentHashMap();
        this.myGlobalLock = new ReentrantReadWriteLock(true);
        this.myDataProvider = dataProvider;
    }

    public boolean containsKey(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/SynchroDictionary", "containsKey"));
        }
        return this.myObjects.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/SynchroDictionary", "get"));
        }
        V value = this.myObjects.get(key);
        if (value == null) {
            Object lock = this.getLock(key);
            this.myGlobalLock.readLock().lock();
            try {
                Object object = lock;
                synchronized (object) {
                    value = this.myObjects.get(key);
                    if (value == null && (value = this.myDataProvider.apply(key)) != null) {
                        this.myObjects.put(key, value);
                    }
                }
            }
            finally {
                this.myGlobalLock.readLock().unlock();
            }
        }
        return value;
    }

    @NotNull
    private Object getLock(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/SynchroDictionary", "getLock"));
        }
        Object lock = this.myLocks.get(key);
        if (lock == null) {
            this.myLocks.putIfAbsent(key, new Object());
            lock = this.myLocks.get(key);
            assert (lock != null);
        }
        Object object = lock;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/SynchroDictionary", "getLock"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(@NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/util/SynchroDictionary", "invalidate"));
        }
        Object lock = this.getLock(key);
        this.myGlobalLock.readLock().lock();
        try {
            Object object = lock;
            synchronized (object) {
                this.myObjects.remove(key);
                this.myLocks.remove(key);
            }
        }
        finally {
            this.myGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        this.myGlobalLock.writeLock().lock();
        try {
            this.myObjects.clear();
            this.myLocks.clear();
        }
        finally {
            this.myGlobalLock.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<K, V> {
        @Nullable
        public V apply(@NotNull K var1);
    }
}

