/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UptodateValue<T> {
    private final ValueProvider<T> myProvider;
    private final TimeToLiveProvider myTtlProvider;
    private final ReentrantReadWriteLock myLock;
    private long myLastUpdateTime;
    private T myCachedValue;
    private final TimeService myTimeService;

    public UptodateValue(@NotNull ValueProvider<T> provider, long timeToLiveMillis) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "jetbrains/buildServer/util/UptodateValue", "<init>"));
        }
        this(provider, timeToLiveMillis, SystemTimeService.getInstance());
    }

    public UptodateValue(ValueProvider<T> provider, long ttl, TimeService timeService) {
        this(provider, new ConstantTTL(ttl), timeService);
    }

    public UptodateValue(ValueProvider<T> provider, @NotNull TimeToLiveProvider ttlProvider, TimeService timeService) {
        if (ttlProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ttlProvider", "jetbrains/buildServer/util/UptodateValue", "<init>"));
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myLastUpdateTime = -1L;
        this.myCachedValue = null;
        this.myProvider = provider;
        this.myTtlProvider = ttlProvider;
        this.myTimeService = timeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getValue() {
        this.myLock.readLock().lock();
        try {
            if (this.isValid()) {
                T t = this.myCachedValue;
                return t;
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
        this.myLock.writeLock().lock();
        try {
            if (!this.isValid()) {
                this.myCachedValue = this.myProvider.getNewValue();
                this.myLastUpdateTime = this.myTimeService.now();
            }
            T t = this.myCachedValue;
            return t;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.myLock.writeLock().lock();
        try {
            this.myCachedValue = null;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    private boolean isValid() {
        return this.myCachedValue != null && this.myTimeService.now() - this.myLastUpdateTime <= this.myTtlProvider.getTimeToLiveMillis();
    }

    private static class ConstantTTL
    implements TimeToLiveProvider {
        private final long myTtl;

        private ConstantTTL(long ttl) {
            this.myTtl = ttl;
        }

        public long getTimeToLiveMillis() {
            return this.myTtl;
        }
    }

    public static interface TimeToLiveProvider {
        public long getTimeToLiveMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueProvider<T> {
        public T getNewValue();
    }
}

