/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.lang.reflect.Method;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.WatchDog;
import org.jetbrains.annotations.Nullable;

public abstract class WaitFor {
    private long myPollInterval = 10L;

    protected WaitFor() {
        this(120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaitFor(@Nullable String optionalWatchDogName, long timeout) {
        long started = System.currentTimeMillis();
        WatchDog watchDog = null;
        if (optionalWatchDogName != null) {
            watchDog = new WatchDog(optionalWatchDogName);
        }
        try {
            while (true) {
                if (this.condition()) {
                    return;
                }
                if (System.currentTimeMillis() - started >= timeout) break;
                Thread.sleep(this.myPollInterval);
            }
            if (LogInitializer.isUnitTest() && timeout >= 1000L && !this.condition()) {
                this.dumpStack();
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            if (watchDog != null) {
                watchDog.stop();
            }
        }
    }

    protected void dumpStack() {
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass("jetbrains.buildServer.BaseTestCase");
            Method method = aClass.getMethod("threadDump", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread.dumpStack();
    }

    protected WaitFor(long timeout) {
        this(null, timeout);
    }

    protected WaitFor(long timeout, long pollInterval) {
        this(null, timeout);
        this.myPollInterval = pollInterval;
    }

    protected abstract boolean condition();
}

