/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static final String PARAMETER_ELEMENT_NAME = "param";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDocument(Document document, OutputStream os) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, Charset.forName("UTF-8"));
        try {
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setEncoding("UTF-8");
            new XMLOutputter(format).output(document, (Writer)writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static boolean isSecureParameter(String parameterName) {
        return parameterName.startsWith("secure:");
    }

    public static Element writeParameter(Element parentElement, String name, String value) {
        boolean multiline;
        String val = value;
        if (XmlUtil.isSecureParameter(name)) {
            val = EncryptUtil.scramble(value);
        }
        Element paramElement = new Element(PARAMETER_ELEMENT_NAME);
        parentElement.addContent((Content)paramElement);
        paramElement.setAttribute("name", name);
        boolean bl = multiline = value.indexOf(10) != -1;
        if (!multiline) {
            paramElement.setAttribute("value", val);
        } else if (value.indexOf("<![CDATA[") != -1) {
            paramElement.addContent(val);
        } else {
            paramElement.addContent((Content)new CDATA(val));
        }
        return paramElement;
    }

    @NotNull
    public static Pair<String, String> readParameter(@NotNull Element paramElement) {
        if (paramElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramElement", "jetbrains/buildServer/util/XmlUtil", "readParameter"));
        }
        String name = paramElement.getAttributeValue("name");
        String value = paramElement.getAttributeValue("value");
        if (value == null) {
            value = paramElement.getTextTrim();
        }
        if (value == null) {
            value = "";
        }
        if (!StringUtil.isEmpty((String)value) && XmlUtil.isSecureParameter(name)) {
            value = EncryptUtil.unscramble(value);
        }
        Pair pair = new Pair((Object)name, (Object)value);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "readParameter"));
        }
        return pair;
    }

    public static void writeParameters(Element parentElement, Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String val = params.get(key);
            XmlUtil.writeParameter(parentElement, key, val);
        }
    }

    @NotNull
    public static Map<String, String> readParameters(@NotNull Element parametersElement) {
        if (parametersElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersElement", "jetbrains/buildServer/util/XmlUtil", "readParameters"));
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List parametersElements = parametersElement.getChildren(PARAMETER_ELEMENT_NAME);
        for (Object obj : parametersElements) {
            Element parameter = (Element)obj;
            Pair<String, String> param = XmlUtil.readParameter(parameter);
            result.put((String)param.getFirst(), (String)param.getSecond());
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "readParameters"));
        }
        return linkedHashMap;
    }

    public static String to_s(Element el) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(el);
    }

    public static Element from_s(String xmlString) {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setReuseParser(false);
            saxBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            return saxBuilder.build((Reader)new CharSequenceReader((CharSequence)xmlString)).getRootElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String formatXml(@NotNull String xmlString) {
        if (xmlString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlString", "jetbrains/buildServer/util/XmlUtil", "formatXml"));
        }
        String string = XmlUtil.to_s(XmlUtil.from_s(xmlString));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "formatXml"));
        }
        return string;
    }

    @Nullable
    public static Element selectElement(@NotNull Element element, @NotNull XPath xpath) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectElement"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectElement"));
        }
        try {
            Object node = xpath.selectSingleNode((Object)element);
            return node != null ? (Element)node : null;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to get first element using XPath (" + xpath.toString() + "): " + je.getMessage(), je);
        }
    }

    @Nullable
    public static Element selectElement(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectElement"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectElement"));
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        return XmlUtil.selectElement(element, xp);
    }

    @NotNull
    public static Element getElement(@NotNull Element element, @NotNull String xpath) throws NoSuchElementException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "getElement"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "getElement"));
        }
        Element found = XmlUtil.selectElement(element, xpath);
        if (found == null) {
            throw new NoSuchElementException("The given XML document has no element \"" + xpath + "\"");
        }
        Element element2 = found;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "getElement"));
        }
        return element2;
    }

    @Nullable
    public static String selectValue(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectValue"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectValue"));
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        return XmlUtil.selectValue(element, xp);
    }

    @Nullable
    public static String selectValue(@NotNull Element element, @NotNull XPath xpath) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectValue"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectValue"));
        }
        try {
            Object node = xpath.selectSingleNode((Object)xpath);
            return node != null ? XmlUtil.getNodeValue(node) : null;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to get first value using XPath (" + xpath.toString() + "): " + je.getMessage(), je);
        }
    }

    @NotNull
    public static List<Element> selectElements(@NotNull Element element, @NotNull XPath xpath) {
        ArrayList<Element> arrayList;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        try {
            List nodes = xpath.selectNodes((Object)element);
            ArrayList<Element> elements = new ArrayList<Element>(nodes.size());
            for (Object node : nodes) {
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
            arrayList = elements;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to select elements by XPath (" + xpath + "): " + je.getMessage(), je);
        }
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Element> selectElements(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        List<Element> list = XmlUtil.selectElements(element, xp);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "selectElements"));
        }
        return list;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesFromFileByXPath(final @NotNull File xmlFile, final @NotNull String xpath, final @NotNull C collection) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "jetbrains/buildServer/util/XmlUtil", "collectValuesFromFileByXPath"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "collectValuesFromFileByXPath"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/XmlUtil", "collectValuesFromFileByXPath"));
        }
        final XPath xp = XmlUtil.compileXPath(xpath);
        FileUtil.readXmlFile(xmlFile, new FileUtil.Processor(){

            public void process(Element rootElement) {
                try {
                    XmlUtil.collectValuesByXPath(rootElement, xp, collection);
                }
                catch (JDOMException je) {
                    throw new RuntimeException("Failed to handle file \"" + xmlFile + "\" and select nodes \"" + xpath + "\": " + je.getMessage(), je);
                }
            }
        });
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "collectValuesFromFileByXPath"));
        }
        return c;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesByXPath(@NotNull Element element, @NotNull String xpath, @NotNull C collection) throws JDOMException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        C c = XmlUtil.collectValuesByXPath(element, xp, collection);
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        return c;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesByXPath(@NotNull Element element, @NotNull XPath xpath, @NotNull C collection) throws JDOMException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        if (xpath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xpath", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        for (Object node : xpath.selectNodes((Object)element)) {
            String value = XmlUtil.getNodeValue(node);
            if (value == null) continue;
            collection.add((String)value);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "collectValuesByXPath"));
        }
        return c;
    }

    @NotNull
    public static XPath compileXPath(String xpath) {
        XPath xp;
        try {
            xp = XPath.newInstance((String)xpath);
        }
        catch (JDOMException je) {
            throw new IllegalArgumentException("Invalid XPath \"" + xpath + "\": " + je.getMessage(), je);
        }
        XPath xPath = xp;
        if (xPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "compileXPath"));
        }
        return xPath;
    }

    @Nullable
    private static String getNodeValue(@NotNull Object node) {
        String value;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "jetbrains/buildServer/util/XmlUtil", "getNodeValue"));
        }
        if (node instanceof Attribute) {
            Attribute attr = (Attribute)node;
            value = attr.getValue();
        } else if (node instanceof Element) {
            Element elem = (Element)node;
            value = elem.getTextTrim();
        } else {
            value = node.toString().trim();
        }
        return value;
    }

    @NotNull
    public static Element addTextChild(@NotNull Element element, @NotNull String childName, @Nullable String childText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "jetbrains/buildServer/util/XmlUtil", "addTextChild"));
        }
        if (childName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childName", "jetbrains/buildServer/util/XmlUtil", "addTextChild"));
        }
        Element child = new Element(childName);
        if (childText != null) {
            child.setText(childText);
        }
        element.addContent(child);
        Element element2 = child;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "addTextChild"));
        }
        return element2;
    }

    @NotNull
    public static Element makeElement(@NotNull String name, String ... attributes) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/util/XmlUtil", "makeElement"));
        }
        Element element = new Element(name);
        for (int i = 0; i < attributes.length; i += 2) {
            element.setAttribute(attributes[i], attributes[i + 1]);
        }
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XmlUtil", "makeElement"));
        }
        return element2;
    }
}

