/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.filters;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredIterator<T>
implements Iterator<T> {
    @NotNull
    private Iterator<T> myDelegate;
    @NotNull
    private Filter<? super T> myFilter;
    @Nullable
    private T myCurrent;
    private boolean myHasCurrent;

    public FilteredIterator(@NotNull Iterator<T> delegate, @NotNull Filter<? super T> filter) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "jetbrains/buildServer/util/filters/FilteredIterator", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/filters/FilteredIterator", "<init>"));
        }
        this.myDelegate = delegate;
        this.myFilter = filter;
        this.findNextAcceptable();
    }

    @Override
    public boolean hasNext() {
        return this.myHasCurrent;
    }

    @Override
    @Nullable
    public T next() {
        if (!this.myHasCurrent) {
            throw new NoSuchElementException();
        }
        T result = this.myCurrent;
        this.findNextAcceptable();
        return result;
    }

    private void findNextAcceptable() {
        this.myHasCurrent = false;
        while (this.myDelegate.hasNext()) {
            T next = this.myDelegate.next();
            if (!this.myFilter.accept(next)) continue;
            this.myCurrent = next;
            this.myHasCurrent = true;
            break;
        }
    }

    @Override
    public void remove() {
        this.myDelegate.remove();
    }
}

