/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.FileRuleSet;
import jetbrains.buildServer.vcs.IncludeRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckoutRules
extends FileRuleSet<IncludeRule, FileRule>
implements Loggable {
    public static final CheckoutRules DEFAULT = new CheckoutRules("");
    public static final String INCLUDE_SEP = "=>";

    public CheckoutRules(@NotNull List<String> body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "jetbrains/buildServer/vcs/CheckoutRules", "<init>"));
        }
        super(body);
    }

    public CheckoutRules(@NotNull String body) {
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "jetbrains/buildServer/vcs/CheckoutRules", "<init>"));
        }
        super(body);
    }

    public CheckoutRules(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        super(includeRules, excludeRules);
    }

    @Nullable
    public String map(String path) {
        IncludeRule rule;
        boolean includeAll = this.isIncludeAll();
        if (!includeAll && !this.shouldInclude(path)) {
            return null;
        }
        path = CheckoutRules.preparePath(path);
        if (this.containsWildcards()) {
            return path;
        }
        IncludeRule includeRule = rule = includeAll ? (IncludeRule)this.getIncludeRules().get(0) : (IncludeRule)CheckoutRules.findMostSpecific(path, this.getIncludeRules());
        if (rule != null) {
            return rule.map(path);
        }
        throw new RuntimeException("Cannot map file path '" + path + "; : include rule not found " + this.toString());
    }

    private boolean isIncludeAll() {
        List includeRules = this.getIncludeRules();
        List excludeRules = this.getExcludeRules();
        return excludeRules.size() == 0 && includeRules.size() == 1 && ((IncludeRule)includeRules.get(0)).getFrom().length() == 0;
    }

    @Override
    public boolean shouldInclude(String path) {
        return this.containsWildcards() || super.shouldInclude(path);
    }

    @Override
    public boolean shouldInclude(String path, Map<String, String> props) {
        return this.containsWildcards() || super.shouldInclude(path, props);
    }

    @Override
    protected boolean shouldInclude(String path, @NotNull Filter<FileRule> includeExcludeRulesFilter) {
        if (includeExcludeRulesFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "includeExcludeRulesFilter", "jetbrains/buildServer/vcs/CheckoutRules", "shouldInclude"));
        }
        return this.containsWildcards() || super.shouldInclude(path, includeExcludeRulesFilter);
    }

    @Override
    public boolean shouldInclude(String path, IncludeRule rule) {
        return this.containsWildcards() || super.shouldInclude(path, rule);
    }

    @NotNull
    public static CheckoutRules createCommonRule(@NotNull List<CheckoutRules> ruleses) {
        if (ruleses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleses", "jetbrains/buildServer/vcs/CheckoutRules", "createCommonRule"));
        }
        HashSet<CheckoutRules> ruleSet = new HashSet<CheckoutRules>();
        ruleSet.addAll(ruleses);
        List<IncludeRule> includes = CheckoutRules.buildIncludeUnion(ruleSet);
        List<FileRule> excludes = CheckoutRules.buildExcludeIntersection(ruleSet);
        ArrayList<FileRule> allRules = new ArrayList<FileRule>();
        allRules.addAll(includes);
        allRules.addAll(excludes);
        CheckoutRules.sortByFrom(allRules, false);
        CheckoutRules.filterIncludes(allRules);
        CheckoutRules.sortByFrom(allRules, true);
        CheckoutRules.filterExcludes(allRules);
        CheckoutRules.replaceIncludeToPart(allRules);
        CheckoutRules checkoutRules = new CheckoutRules(CheckoutRules.toString(allRules));
        if (checkoutRules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "createCommonRule"));
        }
        return checkoutRules;
    }

    private static void replaceIncludeToPart(List<FileRule> allRules) {
        for (int i = 0; i < allRules.size(); ++i) {
            FileRule rule = allRules.get(i);
            if (!(rule instanceof IncludeRule)) continue;
            IncludeRule includeRule = (IncludeRule)rule;
            IncludeRule newRule = new IncludeRule(includeRule.getFrom(), includeRule.getFrom(), null);
            allRules.set(i, newRule);
        }
    }

    private static void filterExcludes(List<FileRule> allRules) {
        String prevFrom = null;
        Iterator<FileRule> iterator = allRules.iterator();
        while (iterator.hasNext()) {
            FileRule rule = iterator.next();
            if (rule.isIsInclude()) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(prevFrom, rule.getFrom())) {
                iterator.remove();
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    private static void filterIncludes(List<FileRule> allRules) {
        String prevFrom = null;
        Iterator<FileRule> iterator = allRules.iterator();
        while (iterator.hasNext()) {
            FileRule rule = iterator.next();
            if (!(rule instanceof IncludeRule)) {
                prevFrom = null;
                continue;
            }
            if (prevFrom != null && CheckoutRules.isSubDir(rule.getFrom(), prevFrom)) {
                iterator.remove();
                continue;
            }
            prevFrom = rule.getFrom();
        }
    }

    @NotNull
    private static List<FileRule> buildExcludeIntersection(@NotNull Collection<CheckoutRules> ruleses) {
        if (ruleses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleses", "jetbrains/buildServer/vcs/CheckoutRules", "buildExcludeIntersection"));
        }
        LinkedHashSet<String> selectedPaths = new LinkedHashSet<String>();
        for (CheckoutRules rules : ruleses) {
            for (FileRule excludeRule : rules.getExcludeRules()) {
                String from = excludeRule.getFrom();
                boolean included = true;
                for (CheckoutRules otherRules : ruleses) {
                    if (rules == otherRules || CheckoutRules.isSubDirInExcludes(from, otherRules)) continue;
                    included = false;
                    break;
                }
                if (included && !excludeRule.isRoot()) {
                    block3: for (CheckoutRules otherRules : ruleses) {
                        if (rules == otherRules) continue;
                        for (IncludeRule fr : otherRules.getIncludeRules()) {
                            if (fr.isRoot() || !CheckoutRules.isSubDir(from, fr.getFrom())) continue;
                            included = false;
                            continue block3;
                        }
                    }
                }
                if (!included) continue;
                selectedPaths.add(from);
            }
        }
        ArrayList<FileRule> result = new ArrayList<FileRule>();
        for (String from : selectedPaths) {
            result.add(new FileRule<Object>(from, null, false));
        }
        ArrayList<FileRule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "buildExcludeIntersection"));
        }
        return arrayList;
    }

    private static boolean isSubDirInExcludes(@NotNull String path, @NotNull CheckoutRules parents) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "jetbrains/buildServer/vcs/CheckoutRules", "isSubDirInExcludes"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "jetbrains/buildServer/vcs/CheckoutRules", "isSubDirInExcludes"));
        }
        List excludeRules = parents.getExcludeRules();
        if (excludeRules.isEmpty()) {
            return false;
        }
        for (FileRule parent : excludeRules) {
            if (!CheckoutRules.isSubDir(path, parent.getFrom())) continue;
            return true;
        }
        return false;
    }

    private static List<String> toString(List<FileRule> rules) {
        ArrayList<String> result = new ArrayList<String>();
        for (FileRule rule : rules) {
            result.add(rule.toString());
        }
        return result;
    }

    private static List<IncludeRule> buildIncludeUnion(@NotNull Collection<CheckoutRules> checkoutRuleses) {
        if (checkoutRuleses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRuleses", "jetbrains/buildServer/vcs/CheckoutRules", "buildIncludeUnion"));
        }
        ArrayList<IncludeRule> result = new ArrayList<IncludeRule>();
        for (CheckoutRules checkoutRules : checkoutRuleses) {
            result.addAll(checkoutRules.getIncludeRules());
        }
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "toString"));
        }
        return string;
    }

    @NotNull
    public String getAsString() {
        StringBuilder result = new StringBuilder();
        for (String line : this.getBody()) {
            if (line.length() <= 0) continue;
            result.append(line);
            if (line.endsWith("\n")) continue;
            result.append('\n');
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) == '\n') {
            result.deleteCharAt(result.length() - 1);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "getAsString"));
        }
        return string;
    }

    @NotNull
    private String asString() {
        StringBuffer result = new StringBuffer();
        for (IncludeRule includeRule : this.getIncludeRules()) {
            result.append(includeRule.toString()).append('\n');
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            result.append(excludeRule.toString()).append('\n');
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "asString"));
        }
        return string;
    }

    public static boolean isCorrect(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "jetbrains/buildServer/vcs/CheckoutRules", "isCorrect"));
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0) {
            return true;
        }
        if (trimmed.startsWith(":")) {
            return false;
        }
        if (trimmed.startsWith("-:") && line.indexOf(INCLUDE_SEP) != -1) {
            return false;
        }
        return !trimmed.equals("+:") && !trimmed.equals("-:") && !trimmed.equals(INCLUDE_SEP);
    }

    public List<IncludeRule> getRootIncludeRules() {
        ArrayList<IncludeRule> result = new ArrayList<IncludeRule>();
        result.addAll(this.getIncludeRules());
        CheckoutRules.sortByFrom(result, false);
        HashSet<IncludeRule> processedRules = new HashSet<IncludeRule>();
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            IncludeRule includeRule = (IncludeRule)iterator.next();
            if (!this.shouldInclude(includeRule.getFrom())) {
                iterator.remove();
                continue;
            }
            if (!StringUtil.isEmpty((String)includeRule.getTo()) && !includeRule.getTo().equals(includeRule.getFrom())) continue;
            for (IncludeRule processed : processedRules) {
                if (!CheckoutRules.isSubDir(includeRule.getFrom(), processed.getFrom())) continue;
                iterator.remove();
                break;
            }
            processedRules.add(includeRule);
        }
        return result;
    }

    @NotNull
    public CheckoutRules createNewRulesForPrefix(@NotNull String prefixPath) {
        if (prefixPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixPath", "jetbrains/buildServer/vcs/CheckoutRules", "createNewRulesForPrefix"));
        }
        if (prefixPath.length() == 0) {
            CheckoutRules checkoutRules = this;
            if (checkoutRules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "createNewRulesForPrefix"));
            }
            return checkoutRules;
        }
        ArrayList<String> rules = new ArrayList<String>();
        for (IncludeRule includeRule : this.getIncludeRules()) {
            String to = includeRule.getTo();
            if (to.length() == 0) {
                to = ".";
            }
            if (includeRule.getFrom().length() == 0) {
                rules.add(prefixPath + INCLUDE_SEP + to);
                continue;
            }
            rules.add(prefixPath + "/" + includeRule.getFrom() + INCLUDE_SEP + to);
        }
        for (FileRule excludeRule : this.getExcludeRules()) {
            if (excludeRule.getFrom().length() == 0) {
                rules.add("-:" + prefixPath);
                continue;
            }
            rules.add("-:" + prefixPath + "/" + excludeRule.getFrom());
        }
        CheckoutRules checkoutRules = new CheckoutRules(rules);
        if (checkoutRules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "createNewRulesForPrefix"));
        }
        return checkoutRules;
    }

    @Override
    protected void postProcessCreatedRules(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        super.postProcessCreatedRules(includeRules, excludeRules);
        for (IncludeRule includeRule : includeRules) {
            Iterator<FileRule> iterator = excludeRules.iterator();
            while (iterator.hasNext()) {
                FileRule excludeRule = iterator.next();
                if (!excludeRule.getFrom().equals(includeRule.getFrom())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    protected void doPostInitProcess(List<IncludeRule> includeRules, List<FileRule> excludeRules) {
        CheckoutRules.sortByFrom(includeRules, true);
        CheckoutRules.sortByFrom(excludeRules, true);
    }

    @Override
    protected IncludeRule createNewIncludeRule(String rule) {
        int sepIndex = rule.indexOf(INCLUDE_SEP);
        if (sepIndex < 0) {
            return new IncludeRule(rule, rule, this);
        }
        String from = rule.substring(0, sepIndex).trim();
        String to = rule.substring(sepIndex + INCLUDE_SEP.length()).trim();
        return new IncludeRule(from, to, this);
    }

    @Override
    protected FileRule createNewExcludeRule(String line) {
        return new FileRule<CheckoutRules>(line, this, false);
    }

    @Override
    protected IncludeRule createNewIncludeRule(IncludeRule includeRule) {
        return new IncludeRule(includeRule.getFrom(), includeRule.getTo(), this);
    }

    @Override
    protected FileRule createNewExcludeRule(FileRule includeRule) {
        return new FileRule<CheckoutRules>(includeRule.getFrom(), this, true);
    }

    public static CheckoutRules createOn(String ruleStr) {
        return new CheckoutRules(ruleStr);
    }

    public boolean containsWildcards() {
        for (IncludeRule includeRule : this.getIncludeRules()) {
            if (includeRule.getFrom().contains("*")) {
                return true;
            }
            if (!includeRule.getTo().contains("*")) continue;
            return true;
        }
        for (FileRule fileRule : this.getExcludeRules()) {
            if (!fileRule.getFrom().contains("*")) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckoutRules)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        StringBuilder result = new StringBuilder();
        CheckoutRules.joinWithPrefix(result, this.getIncludeRules(), ";", "+:");
        CheckoutRules.joinWithPrefix(result, this.getExcludeRules(), ";", "-:");
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/CheckoutRules", "describe"));
        }
        return string;
    }

    private static void joinWithPrefix(StringBuilder result, Iterable toJoin, String separator, String prefix) {
        Iterator it = toJoin.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item == null) continue;
            result.append(prefix).append(item);
            if (!it.hasNext()) continue;
            result.append(separator);
        }
    }
}

