/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import jetbrains.buildServer.serverSide.crypt.EncryptUtil;
import jetbrains.buildServer.util.StringUtils;
import jetbrains.buildServer.vcs.VcsRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsUtil {
    private VcsUtil() {
    }

    public static String getSimplifiedName(VcsRoot vcsRoot) {
        return StringUtils.replaceNonAlphaNumericChars(vcsRoot.getName(), '_');
    }

    public static boolean isSecureProperty(String propertyName) {
        return propertyName.startsWith("secure:");
    }

    public static String propertiesToStringSecure(Map<String, String> properties) {
        return VcsUtil.propertiesToString(properties, true);
    }

    public static String propertiesToString(Map<String, String> properties, boolean scrambleSecureProps) {
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(VcsUtil.escapeStr(key));
            builder.append('=');
            String value = properties.get(key);
            if (scrambleSecureProps && VcsUtil.isSecureProperty(key)) {
                value = EncryptUtil.scramble(value);
            }
            builder.append(VcsUtil.escapeStr(value));
            builder.append('\n');
        }
        return builder.toString();
    }

    private static String escapeStr(String str) {
        if (str == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalEscapedStringCount(str);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 45;
                continue;
            }
            if (c == '\\') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 92;
                continue;
            }
            if (c == '=') {
                resultChars[resultPos++] = 92;
                resultChars[resultPos++] = 95;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name) {
        int result = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\n') {
                result += 2;
                continue;
            }
            if (c == '\\') {
                result += 2;
                continue;
            }
            if (c == '=') {
                result += 2;
                continue;
            }
            ++result;
        }
        return result;
    }

    public static Map<String, String> stringToProperties(String string) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(string, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            int sepIndex = s.indexOf(61);
            if (sepIndex < 0) continue;
            String propName = VcsUtil.unescapeStr(s.substring(0, sepIndex));
            String propValue = VcsUtil.unescapeStr(s.substring(sepIndex + 1));
            if (VcsUtil.isSecureProperty(propName)) {
                try {
                    propValue = EncryptUtil.unscramble(propValue);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            result.put(propName, propValue);
        }
        return result;
    }

    private static String unescapeStr(String name) {
        if (name == null) {
            return null;
        }
        int finalCount = VcsUtil.calcFinalUnescapedStringCount(name);
        int len = name.length();
        if (len == finalCount) {
            return name;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < len; ++i) {
            int c = name.charAt(i);
            if (c == 92 && i < len - 1) {
                char nextChar = name.charAt(i + 1);
                if (nextChar == '-') {
                    c = 10;
                    ++i;
                } else if (nextChar == '\\') {
                    c = 92;
                    ++i;
                } else if (nextChar == '_') {
                    c = 61;
                    ++i;
                }
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect unescaping for '" + name + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalUnescapedStringCount(String name) {
        int result = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char nextChar;
            char c = name.charAt(i);
            if (c == '\\' && i < len - 1 && ((nextChar = name.charAt(i + 1)) == '-' || nextChar == '_' || nextChar == '\\')) {
                ++i;
            }
            ++result;
        }
        return result;
    }
}

