/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.vcs.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.util.Hash;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.VcsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsRootImpl
implements VcsRoot {
    private final long myId;
    private volatile String myName;
    private volatile String myVcsName;
    protected final Map<String, String> myProperties;
    @NonNls
    public static final String VCS_NAME_PROP = "vcs";
    @NonNls
    public static final String VCS_ROOT_NAME_PROP = "teamcity:vcsRootName";
    @NonNls
    public static final String BRANCH_SPEC_PROP = "teamcity:branchSpec";
    @NonNls
    protected static final String CHECKOUT_ROOT = "checkout-root";

    /*
     * WARNING - void declaration
     */
    public VcsRootImpl(long id, @NotNull String vcsName, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "<init>"));
        }
        this.myId = id;
        this.myVcsName = vcsName;
        this.myName = (String)properties.get(VCS_ROOT_NAME_PROP);
        if (this.myName == null) {
            this.myName = "unknown";
        }
        HashMap<String, String> propsCopy = new HashMap<String, String>((Map<String, String>)properties);
        propsCopy.remove(CHECKOUT_ROOT);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(VCS_NAME_PROP);
        this.myProperties = propsCopy;
    }

    public VcsRootImpl(long id, String vcsName) {
        this(id, vcsName, Collections.emptyMap());
        this.myName = null;
    }

    public VcsRootImpl(long id, Map<String, String> properties) {
        this(id, properties.get(VCS_NAME_PROP) == null ? "unknown" : properties.get(VCS_NAME_PROP), properties);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public long getId() {
        return this.myId;
    }

    @Override
    public Map<String, String> getPublicProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> prop : this.getProperties().entrySet()) {
            String propName = prop.getKey();
            String propValue = prop.getValue();
            if (VcsUtil.isSecureProperty(propName)) continue;
            result.put(propName, propValue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String propertyName, String propertyValue) {
        Map<String, String> map = this.myProperties;
        synchronized (map) {
            this.myProperties.put(propertyName, propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(@NotNull Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setProperties"));
        }
        Map<String, String> map2 = this.myProperties;
        synchronized (map2) {
            this.myProperties.clear();
            this.myProperties.putAll(map);
        }
    }

    @Override
    @NotNull
    public String getVcsName() {
        String string = this.myVcsName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getVcsName"));
        }
        return string;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    @Override
    public String getProperty(String propertyName, String defaultValue) {
        String result = this.getProperty(propertyName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.myProperties;
        // MONITORENTER : map
        HashMap<String, String> hashMap = new HashMap<String, String>(this.myProperties);
        // MONITOREXIT : map
        if (hashMap != null) return hashMap;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "getProperties"));
    }

    @Override
    public String convertToString() {
        return VcsUtil.propertiesToString(this.createMap(), true);
    }

    @Override
    public String convertToPresentableString() {
        return this.describe(true);
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String basicDescriptionStart = "\"" + this.getName() + "\"" + " {internal id=" + this.getId();
        if (verbose) {
            String string = basicDescriptionStart + ", properties: [" + VcsRootImpl.propertiesToPresentableString(this.createMap()) + "]}";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "describe"));
            }
            return string;
        }
        String string = basicDescriptionStart + "}";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "describe"));
        }
        return string;
    }

    protected static String propertiesToPresentableString(Map<String, String> properties) {
        ArrayList<String> keys = new ArrayList<String>(properties.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (String key : keys) {
            builder.append(key);
            builder.append('=');
            if (VcsUtil.isSecureProperty(key)) {
                builder.append("*****");
            } else {
                builder.append(properties.get(key));
            }
            builder.append("; ");
        }
        return builder.toString();
    }

    @Override
    public long getPropertiesHash() {
        Map<String, String> propsCopy = this.getProperties();
        propsCopy.remove(VCS_NAME_PROP);
        propsCopy.remove(VCS_ROOT_NAME_PROP);
        propsCopy.remove(BRANCH_SPEC_PROP);
        return Hash.calc(VcsUtil.propertiesToString(propsCopy, false));
    }

    @NotNull
    public Map<String, String> createMap() {
        Map<String, String> result = this.getProperties();
        result.put(VCS_NAME_PROP, this.myVcsName);
        result.put(VCS_ROOT_NAME_PROP, this.myName);
        Map<String, String> map = result;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "createMap"));
        }
        return map;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setName"));
        }
        this.myName = name;
    }

    public void setVcsName(@NotNull String vcsName) {
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "jetbrains/buildServer/vcs/impl/VcsRootImpl", "setVcsName"));
        }
        this.myVcsName = vcsName;
    }

    public static boolean isEquivalentRoots(VcsRoot root1, VcsRoot root2) {
        if (!root1.getVcsName().equals(root2.getVcsName())) {
            return false;
        }
        return ((Object)root1.getProperties()).equals(root2.getProperties());
    }

    public String toString() {
        return this.getName() + " {id=" + this.getId() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsRootImpl vcsRoot = (VcsRootImpl)o;
        return this.myId == vcsRoot.myId;
    }

    public int hashCode() {
        return (int)(this.myId ^ this.myId >>> 32);
    }

    public static String propertiesToString(Map<String, String> properties) {
        return VcsUtil.propertiesToStringSecure(properties);
    }

    public static String propertiesToString(Map<String, String> properties, boolean scrambleSecureProps) {
        return VcsUtil.propertiesToString(properties, scrambleSecureProps);
    }

    public static Map<String, String> stringToProperties(String string) {
        return VcsUtil.stringToProperties(string);
    }

    public static boolean isSecureProperty(String propertyName) {
        return VcsUtil.isSecureProperty(propertyName);
    }
}

