/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.xmlrpc;

import java.net.MalformedURLException;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;
import jetbrains.buildServer.xmlrpc.impl.CommonsXmlRpcTargetImpl;
import jetbrains.buildServer.xmlrpc.impl.XmlRpcTargetImpl;

public class XmlRpcFactory {
    private static XmlRpcFactory ourInstance;
    private final ProxySettings myProxySettings = new ProxySettings();

    public static XmlRpcFactory getInstance() {
        if (ourInstance == null) {
            ourInstance = new XmlRpcFactory();
        }
        return ourInstance;
    }

    public XmlRpcTarget createCommonsHttpTransportTarget(String serverUrl, String userAgent, int timeout, boolean keepAlive) {
        try {
            CommonsXmlRpcTargetImpl target = new CommonsXmlRpcTargetImpl(serverUrl, userAgent, timeout, keepAlive);
            if (this.myProxySettings.isConfigured()) {
                target.setProxy(this.myProxySettings.getHost(), this.myProxySettings.getPort());
                if (this.myProxySettings.isCredentialsSpecified()) {
                    target.setProxyCredentials(this.myProxySettings.getUsername(), this.myProxySettings.getPassword());
                }
            }
            return target;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private XmlRpcTarget createDefaultTarget(String serverUrl, String userAgent, int timeout) {
        return new XmlRpcTargetImpl(serverUrl, userAgent, timeout);
    }

    public XmlRpcTarget create(String serverUrl, String userAgent, int timeoutMillis, boolean useApacheCommonsTransport) {
        if (useApacheCommonsTransport) {
            return this.createCommonsHttpTransportTarget(serverUrl, userAgent, timeoutMillis, true);
        }
        return this.createDefaultTarget(serverUrl, userAgent, timeoutMillis);
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.myProxySettings.setHost(proxyHost, proxyPort);
    }

    public void setProxyAuthentication(String username, String password) {
        this.myProxySettings.setCredentials(username, password);
    }

    public static void setInstance(XmlRpcFactory instance) {
        ourInstance = instance;
    }

    private static class ProxySettings {
        private String myHost;
        private int myPort;
        private String myUsername;
        private String myPassword;

        private ProxySettings() {
        }

        void setHost(String host, int port) {
            this.myHost = host;
            this.myPort = port;
        }

        void setCredentials(String username, String password) {
            this.myUsername = username;
            this.myPassword = password;
        }

        public String getHost() {
            return this.myHost;
        }

        public int getPort() {
            return this.myPort;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public boolean isConfigured() {
            return this.myHost != null && this.myHost.trim().length() > 0;
        }

        public boolean isCredentialsSpecified() {
            return this.myUsername != null && this.myPassword != null;
        }
    }
}

