/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.vcs.api;

import java.util.Collections;
import java.util.Map;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.vcs.VcsRoot;
import jetbrains.buildServer.vcs.impl.VcsRootImpl;
import jetbrains.vcs.api.data.VcsDataObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VcsSettings
implements Loggable,
VcsDataObject {
    @NotNull
    private final VcsRoot myVcsRoot;
    @NotNull
    private final String myCheckoutRules;

    public VcsSettings(@NotNull VcsRoot vcsRoot, @NotNull String checkoutRules) {
        if (vcsRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsRoot", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
    }

    /*
     * WARNING - void declaration
     */
    public VcsSettings(long settingsId, @NotNull String vcsName, @Nullable String displayName, @NotNull String checkoutRules, @NotNull Map<String, String> map) {
        void properties;
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutRules", "jetbrains/vcs/api/VcsSettings", "<init>"));
        }
        VcsRootImpl vcsRoot = new VcsRootImpl(settingsId, vcsName, (Map<String, String>)properties);
        if (displayName != null) {
            vcsRoot.setName(displayName);
        }
        this.myVcsRoot = vcsRoot;
        this.myCheckoutRules = checkoutRules;
    }

    @NotNull
    public VcsRoot getVcsRoot() {
        VcsRoot vcsRoot = this.myVcsRoot;
        if (vcsRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getVcsRoot"));
        }
        return vcsRoot;
    }

    public long getSettingsId() {
        return this.myVcsRoot.getId();
    }

    @Nullable
    public String getDisplayName() {
        return this.myVcsRoot.getName();
    }

    @NotNull
    public String getVcsName() {
        String string = this.myVcsRoot.getVcsName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getVcsName"));
        }
        return string;
    }

    @NotNull
    public Map<String, String> getProperties() {
        Map<String, String> map = this.myVcsRoot.getProperties();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getProperties"));
        }
        return map;
    }

    @NotNull
    public String getCheckoutRulesSpecification() {
        String string = this.myCheckoutRules;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "getCheckoutRulesSpecification"));
        }
        return string;
    }

    @Override
    @NotNull
    public String describe(boolean verbose) {
        String string = "VcsSettings[" + this.myVcsRoot.describe(verbose) + "; Checkout rules: " + this.myCheckoutRules + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/vcs/api/VcsSettings", "describe"));
        }
        return string;
    }

    public String toString() {
        return this.describe(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VcsSettings)) {
            return false;
        }
        VcsSettings that = (VcsSettings)o;
        if (!this.myCheckoutRules.equals(that.myCheckoutRules)) {
            return false;
        }
        return this.myVcsRoot.equals(that.myVcsRoot);
    }

    public int hashCode() {
        int result = this.myVcsRoot.hashCode();
        result = 31 * result + this.myCheckoutRules.hashCode();
        return result;
    }

    public static VcsSettings forTest(String name) {
        return new VcsSettings(name.hashCode(), name, name, "", Collections.<String, String>emptyMap());
    }
}

