/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.xmlrpc.TCDateTool;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlWriter;

public class TCXmlWriter
extends XmlWriter {
    private final char[] myBuf = new char[1024];

    public TCXmlWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        super(out, enc);
        this.dateTool = new TCDateTool();
    }

    protected void chardata(String text) throws XmlRpcException, IOException {
        String textCopy = this.replaceInvalidEntities(text);
        int index = 0;
        while (index < textCopy.length()) {
            char nextChar;
            int i;
            int dataSize = Math.min(textCopy.length() - index, this.myBuf.length);
            int numBrackets = 0;
            for (i = 0; i < dataSize && ((nextChar = textCopy.charAt(index)) != '>' || numBrackets <= 0); ++i) {
                this.myBuf[i] = nextChar;
                ++index;
                if (nextChar == ']') {
                    ++numBrackets;
                    continue;
                }
                numBrackets = 0;
            }
            this.write("<![CDATA[");
            this.write(this.myBuf, 0, i);
            this.write("]]>");
        }
    }

    private String replaceInvalidEntities(String text) {
        StringBuffer textCopy = new StringBuffer();
        StringBuffer entity = new StringBuffer();
        boolean entityStarted = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                entity.setLength(0);
                entityStarted = true;
                continue;
            }
            if (entityStarted && c != ';') {
                entity.append(c);
                continue;
            }
            if (c == ';' && entityStarted) {
                entityStarted = false;
                if (entity.length() > 2 && entity.charAt(0) == '#') {
                    String code = entity.substring(1);
                    int radix = 10;
                    if (code.charAt(0) == 'x') {
                        code = code.substring(1);
                        radix = 16;
                    }
                    int parsed = 0;
                    boolean valid = true;
                    try {
                        parsed = Integer.parseInt(code, radix);
                        valid = TCXmlWriter.isValidXMLChar((char)parsed);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (valid) {
                        this.appendEntity(textCopy, entity);
                        continue;
                    }
                    textCopy.append(' ');
                    continue;
                }
                this.appendEntity(textCopy, entity);
                continue;
            }
            textCopy.append(c);
        }
        return textCopy.toString();
    }

    private void appendEntity(StringBuffer textCopy, StringBuffer entity) {
        textCopy.append('&');
        textCopy.append(entity.toString());
        textCopy.append(';');
    }

    private static boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\u10ffff';
    }
}

