/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkUtil {
    private static final Logger LOG = Logger.getInstance((String)NetworkUtil.class.getName());

    private NetworkUtil() {
    }

    @NotNull
    public static InetAddress[] getSelfAddresses() throws SocketException {
        InetAddress[] inetAddressArray = NetworkUtil.getSelfAddresses(new Filter<InetAddress>(){

            @Override
            public boolean accept(@NotNull InetAddress data) {
                if (data == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/NetworkUtil$1", "accept"));
                }
                return data instanceof Inet4Address;
            }
        });
        if (inetAddressArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/NetworkUtil", "getSelfAddresses"));
        }
        return inetAddressArray;
    }

    @NotNull
    public static InetAddress[] getSelfAddresses(@Nullable Filter<InetAddress> filter) throws SocketException {
        ArrayList<InetAddress> selfAddresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || filter != null && !filter.accept(inetAddress)) continue;
                selfAddresses.add(inetAddress);
            }
        }
        if (selfAddresses.size() == 0) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                if (filter == null || filter.accept(localHost)) {
                    selfAddresses.add(localHost);
                }
            }
            catch (UnknownHostException e) {
                LOG.error((Throwable)e);
            }
        }
        LOG.debug("Found Network Interfaces: " + selfAddresses);
        InetAddress[] inetAddressArray = selfAddresses.toArray(new InetAddress[selfAddresses.size()]);
        if (inetAddressArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/NetworkUtil", "getSelfAddresses"));
        }
        return inetAddressArray;
    }

    public static boolean isPortBusy(int port) {
        return NetworkUtil.isPortBusy("localhost", port, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortBusy(String host, int port, int connectTimeoutMsecs) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), connectTimeoutMsecs);
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
        return true;
    }

    public static int getFreePort(int i) {
        int numIterations = 0;
        int port = i;
        while (NetworkUtil.isPortBusy(port) && numIterations < 3) {
            if (port == 65535) {
                port = 1025;
                ++numIterations;
            }
            ++port;
        }
        if (numIterations == 3) {
            throw new IllegalStateException("Unable to find free port, tried range: 1025 - 65535");
        }
        return port;
    }

    @NotNull
    public static String getHostAddressWithoutScope(@NotNull Inet6Address ipv6Addr) {
        if (ipv6Addr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ipv6Addr", "jetbrains/buildServer/NetworkUtil", "getHostAddressWithoutScope"));
        }
        String hostAddr = ipv6Addr.getHostAddress();
        int scopeIdStart = hostAddr.indexOf(37);
        if (scopeIdStart != -1) {
            String string = hostAddr.substring(0, scopeIdStart);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/NetworkUtil", "getHostAddressWithoutScope"));
            }
            return string;
        }
        String string = hostAddr;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/NetworkUtil", "getHostAddressWithoutScope"));
        }
        return string;
    }

    public static boolean isLocalHost(@NotNull String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostname", "jetbrains/buildServer/NetworkUtil", "isLocalHost"));
        }
        try {
            InetAddress address = InetAddress.getByName(hostname);
            if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                return true;
            }
            try {
                return NetworkInterface.getByInetAddress(address) != null;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

