/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStream;
import jetbrains.buildServer.CommandLineExecutor;
import jetbrains.buildServer.ExecResult;
import jetbrains.buildServer.ProcessTimeoutException;
import jetbrains.buildServer.StreamGobbler;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleCommandLineProcessRunner {
    private static final Logger LOG = Logger.getInstance((String)SimpleCommandLineProcessRunner.class.getName());

    private SimpleCommandLineProcessRunner() {
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommand"));
        }
        return SimpleCommandLineProcessRunner.runCommand(commandLine, input, new ProcessRunCallbackAdapter());
    }

    public static ExecResult runCommand(@NotNull GeneralCommandLine commandLine, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommand"));
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventHandler", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommand"));
        }
        return SimpleCommandLineProcessRunner.runCommandSecure(commandLine, commandLine.getCommandLineString(), input, eventHandler);
    }

    public static ExecResult runCommandSecure(final @NotNull GeneralCommandLine commandLine, final @NotNull String commandLineToLog, final @Nullable byte[] input, final @NotNull RunCommandEvents eventHandler) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandSecure"));
        }
        if (commandLineToLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineToLog", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandSecure"));
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventHandler", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandSecure"));
        }
        final ExecResult retVal = new ExecResult(commandLine.getCharset());
        LOG.debug("Start process name: " + commandLineToLog);
        int commandLineStrLimit = TeamCityProperties.getInteger("teamcity.externalProcessRunner.limitCommandLineLengthInThreadName", 1000);
        String commandLineStr = StringUtil.truncateStringValueWithDotsAtEnd(commandLine.toString(), commandLineStrLimit);
        NamedThreadFactory.executeWithNewThreadName(commandLineStr, new Runnable(){

            public void run() {
                SimpleCommandLineProcessRunner.runCommandInternal(commandLine, commandLineToLog, input, eventHandler, retVal);
            }
        });
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runCommandInternal(@NotNull GeneralCommandLine commandLine, @NotNull String commandLineToLog, @Nullable byte[] input, @NotNull RunCommandEvents eventHandler, @NotNull ExecResult retVal) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandInternal"));
        }
        if (commandLineToLog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineToLog", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandInternal"));
        }
        if (eventHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventHandler", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandInternal"));
        }
        if (retVal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "retVal", "jetbrains/buildServer/SimpleCommandLineProcessRunner", "runCommandInternal"));
        }
        try {
            Process proc = commandLine.createProcess();
            Integer maxOutputSize = eventHandler instanceof ProcessRunCallback ? ((ProcessRunCallback)eventHandler).getMaxAcceptedOutputSize() : null;
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), maxOutputSize, commandLineToLog);
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), maxOutputSize, commandLineToLog);
            errorGobbler.start();
            outputGobbler.start();
            if (input != null) {
                OutputStream out = proc.getOutputStream();
                try {
                    out.write(input);
                }
                finally {
                    out.close();
                }
            }
            eventHandler.onProcessStarted(proc);
            retVal.setOutputGobbler(outputGobbler);
            retVal.setErrorGobbler(errorGobbler);
            Integer timeout = eventHandler.getOutputIdleSecondsTimeout();
            if (timeout == null) {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler));
            } else {
                retVal.setExitCode(CommandLineExecutor.waitForProcess(proc, errorGobbler, outputGobbler, timeout));
            }
            eventHandler.onProcessFinished(proc);
        }
        catch (Throwable e) {
            if (e instanceof ProcessTimeoutException) {
                ((ProcessTimeoutException)e).setProcessName(commandLine.getCommandLineString());
            }
            retVal.setException(e);
        }
    }

    public static class NoOutputTimeoutProcessRunCallbackAdapter
    extends NoOutputTimeoutRunCommandEventsAdapter {
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class ProcessRunCallbackAdapter
    extends RunCommandEventsAdapter {
    }

    public static class NoOutputTimeoutRunCommandEventsAdapter
    extends RunCommandEventsAdapter {
        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return 0;
        }
    }

    public static class RunCommandEventsAdapter
    implements ProcessRunCallback {
        public void onProcessStarted(@NotNull Process ps) {
            if (ps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ps", "jetbrains/buildServer/SimpleCommandLineProcessRunner$RunCommandEventsAdapter", "onProcessStarted"));
            }
        }

        public void onProcessFinished(@NotNull Process ps) {
            if (ps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ps", "jetbrains/buildServer/SimpleCommandLineProcessRunner$RunCommandEventsAdapter", "onProcessFinished"));
            }
        }

        @Nullable
        public Integer getOutputIdleSecondsTimeout() {
            return null;
        }

        @Nullable
        public Integer getMaxAcceptedOutputSize() {
            return null;
        }
    }

    public static interface ProcessRunCallback
    extends RunCommandEvents {
        @Nullable
        public Integer getMaxAcceptedOutputSize();
    }

    public static interface RunCommandEvents {
        public void onProcessStarted(@NotNull Process var1);

        public void onProcessFinished(@NotNull Process var1);

        @Nullable
        public Integer getOutputIdleSecondsTimeout();
    }
}

