/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class AgentClassLoader
extends URLClassLoader {
    public AgentClassLoader(String agentClasspath, ClassLoader classLoader) {
        super(AgentClassLoader.createUrls(agentClasspath), classLoader);
    }

    public AgentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ("net.sf.cglib.proxy.Enhancer".equals(name)) {
            throw new ClassNotFoundException("CGLIB should not be available here");
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                try {
                    if (name.startsWith("org.xml.sax.") || name.startsWith("com.intellij.rt.coverage")) {
                        c = super.loadClass(name, resolve);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                if (c == null) {
                    c = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                c = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private static URL[] createUrls(String agentClasspath) {
        StringTokenizer tokenizer = new StringTokenizer(agentClasspath, File.pathSeparator, false);
        ArrayList<URL> result = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                result.add(new File(path).toURL());
            }
            catch (MalformedURLException e) {}
        }
        return result.toArray(new URL[result.size()]);
    }
}

