/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.agent.IOUtil;
import jetbrains.buildServer.agent.VcsChange;

public class ChangedFiles {
    private List myNewOrModifiedFilePaths;

    public static ChangedFiles create() {
        return new ChangedFiles();
    }

    public List getNewOrModifiedFiles() {
        if (this.myNewOrModifiedFilePaths == null) {
            this.myNewOrModifiedFilePaths = new ArrayList();
            this.loadNewAndModifiedFiles();
        }
        return this.myNewOrModifiedFilePaths;
    }

    private void loadNewAndModifiedFiles() {
        String filePath = System.getProperty("teamcity.build.changedFiles.file");
        if (filePath == null) {
            return;
        }
        File file = new File(filePath);
        if (!file.isFile()) {
            return;
        }
        String checkoutDir = System.getProperty("teamcity.build.checkoutDir");
        List lines = IOUtil.readLines(file);
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            VcsChange change = VcsChange.parse(line);
            if (change == null) continue;
            change.setCheckoutDir(checkoutDir);
            if (!change.getChangeType().equals("CHANGED") && !change.getChangeType().equals("ADDED")) continue;
            this.myNewOrModifiedFilePaths.add(change);
        }
        Collections.sort(this.myNewOrModifiedFilePaths);
    }
}

