/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.agent.AgentClassLoader;
import jetbrains.buildServer.agent.FlowLogger;
import jetbrains.buildServer.agent.RuntimeProperties;

public class LoggerFactory {
    private static final String LOGGER_FACADE_IMPL_CLASS_NAME = "jetbrains.buildServer.agent.ant.ServerLoggerFacade";
    private static final Map ourLoggersMap = new HashMap();

    public static FlowLogger createBuildProgressLogger(ClassLoader parent) {
        Object bpl = LoggerFactory.createLoggerFacade(parent);
        return (FlowLogger)bpl;
    }

    private static Object createLoggerFacade(ClassLoader parentLoader) {
        return LoggerFactory.createAgentObject(parentLoader, LOGGER_FACADE_IMPL_CLASS_NAME);
    }

    public static Object createAgentObject(ClassLoader parentLoader, String className) {
        String key = className + System.identityHashCode(parentLoader instanceof AgentClassLoader ? parentLoader.getParent() : parentLoader);
        Object instance = ourLoggersMap.get(key);
        if (instance != null) {
            return instance;
        }
        try {
            String agentClassspath = RuntimeProperties.getInstance().getRuntimeClasspath();
            if (agentClassspath != null && !(parentLoader instanceof AgentClassLoader)) {
                AgentClassLoader loader = new AgentClassLoader(agentClassspath, parentLoader);
                return LoggerFactory.loadAndInstantiateClass(className, key, loader);
            }
            return LoggerFactory.loadAndInstantiateClass(className, key, parentLoader);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
            throw new RuntimeException("Cannot instantiate class jetbrains.buildServer.agent.ant.ServerLoggerFacade: " + e1.getLocalizedMessage());
        }
    }

    private static Object loadAndInstantiateClass(String className, String classKey, ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object loggerFacadeInstance;
        Class<?> aClass = loader.loadClass(className);
        try {
            loggerFacadeInstance = aClass.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            e.getException().printStackTrace();
            throw new RuntimeException(e.toString());
        }
        ourLoggersMap.put(classKey, loggerFacadeInstance);
        return loggerFacadeInstance;
    }

    public static void reset() {
        ourLoggersMap.clear();
    }
}

