/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent;

import java.io.File;
import java.util.StringTokenizer;

public class VcsChange
implements Comparable {
    private static final String PERSONAL_CHANGE_REVISION = "<personal>";
    private String myRelativePath;
    private String myChangeType;
    private String myRevision = "";
    private String myBasePath;

    public static VcsChange parse(String line) {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (st.countTokens() == 3 || st.countTokens() == 2) {
            VcsChange change = new VcsChange();
            change.myRelativePath = st.nextToken();
            change.myChangeType = st.nextToken();
            if (st.hasMoreTokens()) {
                change.myRevision = st.nextToken();
            }
            return change;
        }
        return null;
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public String getAbsolutePath() {
        return new File(this.myBasePath, this.myRelativePath).getAbsolutePath();
    }

    public String getChangeType() {
        return this.myChangeType;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public boolean isPersonal() {
        return PERSONAL_CHANGE_REVISION.equals(this.myRevision);
    }

    public void setCheckoutDir(String checkoutDir) {
        this.myBasePath = checkoutDir;
    }

    public boolean isRelatedToClass(String className) {
        String probablyClassName = this.getAbsolutePath().replace('/', '.').replace('\\', '.');
        return probablyClassName.endsWith(className + ".java");
    }

    public int compareTo(Object o) {
        VcsChange change = (VcsChange)o;
        if (this.isPersonal() && !change.isPersonal()) {
            return -1;
        }
        if (change.isPersonal() && !this.isPersonal()) {
            return 1;
        }
        if ("ADDED".equals(this.getChangeType()) && !"ADDED".equals(change.getChangeType())) {
            return -1;
        }
        if (!"ADDED".equals(this.getChangeType()) && "ADDED".equals(change.getChangeType())) {
            return 1;
        }
        return this.getRelativePath().compareTo(change.getRelativePath());
    }
}

