/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agent.impl;

import java.util.Date;
import java.util.Vector;
import jetbrains.buildServer.agentServer.AgentLogListener;
import jetbrains.buildServer.xmlrpc.RemoteCallException;
import jetbrains.buildServer.xmlrpc.XmlRpcFactory;
import jetbrains.buildServer.xmlrpc.XmlRpcTarget;

public class XmlRpcAgentLogListener
implements AgentLogListener {
    protected XmlRpcTarget myTarget;
    protected final String myMethodPrefix;
    private final boolean myUseApacheCommonsTransport;

    public XmlRpcAgentLogListener(int localPort) {
        this("http://localhost:" + localPort, "buildAgent", false, 0);
    }

    protected XmlRpcAgentLogListener(String serverUrl, int connectionTimeout) {
        this(serverUrl, "buildServer", true, connectionTimeout);
    }

    private XmlRpcAgentLogListener(String serverUrl, String xmlRpcPrefix, boolean useApacheCommonsTransport, int connectionTimeout) {
        this.myMethodPrefix = xmlRpcPrefix;
        this.myUseApacheCommonsTransport = useApacheCommonsTransport;
        this.initTarget(serverUrl, connectionTimeout);
    }

    private void initTarget(String serverUrl, int connectionTimeout) {
        XmlRpcTarget oldTarget = this.myTarget;
        this.myTarget = XmlRpcFactory.getInstance().create(serverUrl, "TeamCity Agent", XmlRpcAgentLogListener.isUnitTest() ? 60000 : connectionTimeout * 1000, this.myUseApacheCommonsTransport);
        if (oldTarget != null) {
            oldTarget.disposeConnections();
        }
    }

    private static boolean isUnitTest() {
        return "yes".equals(System.getProperty("jetbrains.unit.test"));
    }

    public boolean log(final String buildId, final Vector messagesXml) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                Boolean result = (Boolean)XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + "." + "log", new Object[]{buildId, messagesXml});
                return result;
            }
        });
    }

    public boolean buildFinished(final String buildId, final Date finishDate, final boolean buildFailed) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".buildFinished", new Object[]{buildId, finishDate, buildFailed ? Boolean.TRUE : Boolean.FALSE});
                return true;
            }
        });
    }

    public boolean buildInterrupted(final String buildId) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".buildInterrupted", new Object[]{buildId});
                return true;
            }
        });
    }

    public boolean markCheckoutDirClean(final String buildId) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".markCheckoutDirClean", new Object[]{buildId});
                return true;
            }
        });
    }

    public boolean markCheckoutDirDirty(final String buildId) {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".markCheckoutDirDirty", new Object[]{buildId});
                return true;
            }
        });
    }

    public boolean isBuildFailing(final String buildId) throws InterruptedException {
        return this.doSendRequest(new RemoteCall(){

            public boolean invoke() {
                return (Boolean)XmlRpcAgentLogListener.this.myTarget.call(XmlRpcAgentLogListener.this.myMethodPrefix + ".isBuildFailing", new Object[]{buildId});
            }
        });
    }

    private boolean doSendRequest(RemoteCall call) {
        try {
            return call.invoke();
        }
        catch (RemoteCallException e) {
            if (e.getMessage().indexOf("403") != -1) {
                this.initTarget(this.myTarget.getServerURL(), 0);
                return call.invoke();
            }
            throw e;
        }
    }

    public String toString() {
        return this.myMethodPrefix + " " + this.myTarget;
    }

    static interface RemoteCall {
        public boolean invoke();
    }
}

