/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.thoughtworks.xstream.XStream;
import java.util.Date;
import java.util.TimeZone;
import jetbrains.buildServer.messages.XStreamHolder;
import jetbrains.buildServer.xstream.XStreamWrapper;
import org.jetbrains.annotations.NotNull;

public class AgentBuildResult {
    private final long myBuildStartTimeMilliseconds;
    @NotNull
    private final String myAgentTimeZone;

    public AgentBuildResult() {
        this(System.currentTimeMillis());
    }

    public AgentBuildResult(long buildStartTimeMilliseconds) {
        this(new Date(buildStartTimeMilliseconds));
    }

    public AgentBuildResult(@NotNull Date buildStartTime) {
        if (buildStartTime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildStartTime", "jetbrains/buildServer/agentServer/AgentBuildResult", "<init>"));
        }
        this.myBuildStartTimeMilliseconds = buildStartTime.getTime();
        this.myAgentTimeZone = TimeZone.getDefault().getID();
    }

    /*
     * WARNING - void declaration
     */
    public AgentBuildResult(long buildStartTimeMilliseconds, @NotNull String string) {
        void agentTimeZone;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "jetbrains/buildServer/agentServer/AgentBuildResult", "<init>"));
        }
        this.myBuildStartTimeMilliseconds = buildStartTimeMilliseconds;
        this.myAgentTimeZone = agentTimeZone;
    }

    @NotNull
    public Date getAgentBuildStartTimeUTC() {
        Date date = new Date(this.myBuildStartTimeMilliseconds);
        if (date == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentBuildResult", "getAgentBuildStartTimeUTC"));
        }
        return date;
    }

    @NotNull
    public TimeZone getAgentTimeZone() {
        TimeZone timeZone = TimeZone.getTimeZone(this.myAgentTimeZone);
        if (timeZone == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentBuildResult", "getAgentTimeZone"));
        }
        return timeZone;
    }

    @NotNull
    public String serialize() {
        String string = XStreamWrapper.serializeObject(this, AgentBuildResult.createXStreamHolder());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentBuildResult", "serialize"));
        }
        return string;
    }

    @NotNull
    public static AgentBuildResult deserialize(@NotNull String serialized) {
        if (serialized == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serialized", "jetbrains/buildServer/agentServer/AgentBuildResult", "deserialize"));
        }
        AgentBuildResult agentBuildResult = (AgentBuildResult)XStreamWrapper.deserializeObject(serialized, AgentBuildResult.createXStreamHolder());
        if (agentBuildResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentBuildResult", "deserialize"));
        }
        return agentBuildResult;
    }

    @NotNull
    private static XStreamHolder createXStreamHolder() {
        XStreamHolder xStreamHolder = new XStreamHolder(){

            protected void configureXStream(XStream xStream) {
                xStream.alias("AgentBuildResult", AgentBuildResult.class);
            }
        };
        if (xStreamHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentBuildResult", "createXStreamHolder"));
        }
        return xStreamHolder;
    }

    public String toString() {
        return "AgentBuildResult{myBuildStartTimeMilliseconds='" + this.myBuildStartTimeMilliseconds + "', myAgentTimeZone='" + this.myAgentTimeZone + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentBuildResult that = (AgentBuildResult)o;
        return this.myBuildStartTimeMilliseconds == that.myBuildStartTimeMilliseconds && this.myAgentTimeZone.equals(that.myAgentTimeZone);
    }

    public int hashCode() {
        int result = (int)(this.myBuildStartTimeMilliseconds ^ this.myBuildStartTimeMilliseconds >>> 32);
        result = 31 * result + this.myAgentTimeZone.hashCode();
        return result;
    }
}

