/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.CheckoutRules;
import org.apache.log4j.lf5.util.StreamUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentCheckoutDirRevisionInfo {
    private final List<VcsRootInstanceState> myInstancesStates;
    private final String myCheckoutDirPath;
    private final Map<String, Long> myLastBuilds;
    private final String myVcsSettingsHash;

    public static AgentCheckoutDirRevisionInfo createEmptyState() {
        return new AgentCheckoutDirRevisionInfo();
    }

    @NotNull
    public static AgentCheckoutDirRevisionInfo parseXml(@NotNull InputStream is) throws IOException {
        AgentCheckoutDirRevisionInfo agentCheckoutDirRevisionInfo;
        if (is == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "parseXml"));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String checkoutDirPath = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "/CheckoutDirectoryState/CheckoutDirPath", document.getDocumentElement());
            String vcsSettingsHash = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "/CheckoutDirectoryState/VcsSettingsHash", document.getDocumentElement());
            NodeList buildsList = (NodeList)xPath.evaluate("/CheckoutDirectoryState/BuildHistory/Build", document.getDocumentElement(), XPathConstants.NODESET);
            HashMap<String, Long> buildsMap = new HashMap<String, Long>();
            for (int i = 0; i < buildsList.getLength(); ++i) {
                Node item = buildsList.item(i);
                String buildTypeId = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "BuildTypeId", (Element)item);
                String buildId = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "BuildId", (Element)item);
                buildsMap.put(buildTypeId, Long.parseLong(buildId));
            }
            AgentCheckoutDirRevisionInfo retval = new AgentCheckoutDirRevisionInfo(checkoutDirPath, vcsSettingsHash, buildsMap);
            NodeList nodeList = (NodeList)xPath.evaluate("/CheckoutDirectoryState/VcsRoots/VcsRoot", document.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node item = nodeList.item(i);
                String revision = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "Revision", (Element)item);
                String internalId = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "InternalId", (Element)item);
                String checkoutRules = AgentCheckoutDirRevisionInfo.getStringFromXPath(xPath, "CheckoutRules", (Element)item);
                retval.addVcsRootInstanceState(revision, Long.parseLong(internalId), new CheckoutRules(checkoutRules));
            }
            AgentCheckoutDirRevisionInfo agentCheckoutDirRevisionInfo2 = retval;
            agentCheckoutDirRevisionInfo = agentCheckoutDirRevisionInfo2;
        }
        catch (Exception e) {
            throw new IOException("An error occurred while trying to deserialize AgentCheckoutDirRevisionInfo", e);
        }
        finally {
            FileUtil.close(is);
        }
        if (agentCheckoutDirRevisionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "parseXml"));
        }
        return agentCheckoutDirRevisionInfo;
    }

    private AgentCheckoutDirRevisionInfo() {
        this.myInstancesStates = Collections.emptyList();
        this.myCheckoutDirPath = "";
        this.myVcsSettingsHash = "";
        this.myLastBuilds = Collections.emptyMap();
    }

    private AgentCheckoutDirRevisionInfo(String checkoutDirPath, String vcsSettingsHash, Map<String, Long> lastBuilds) {
        this.myInstancesStates = new ArrayList<VcsRootInstanceState>();
        this.myCheckoutDirPath = checkoutDirPath;
        this.myVcsSettingsHash = vcsSettingsHash;
        this.myLastBuilds = lastBuilds;
    }

    public AgentCheckoutDirRevisionInfo(@NotNull File checkoutDir, @NotNull File agentWorkdir, @NotNull String vcsSettingsHash) {
        if (checkoutDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkoutDir", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (agentWorkdir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agentWorkdir", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (vcsSettingsHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettingsHash", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        this(FileUtil.getNameOrAbsolutePath(agentWorkdir, checkoutDir), vcsSettingsHash, new HashMap<String, Long>());
    }

    /*
     * WARNING - void declaration
     */
    public AgentCheckoutDirRevisionInfo(@NotNull AgentCheckoutDirRevisionInfo oldInfo, @NotNull String vcsSettingsHash, @NotNull String buildTypeId, long buildId, boolean bl) {
        void fullCheckout;
        if (oldInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInfo", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (vcsSettingsHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettingsHash", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        if (buildTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeId", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "<init>"));
        }
        this(oldInfo.getCheckoutDirPath(), vcsSettingsHash, (Map<String, Long>)new HashMap<String, Long>((boolean)fullCheckout, vcsSettingsHash, oldInfo){
            final /* synthetic */ boolean val$fullCheckout;
            final /* synthetic */ String val$vcsSettingsHash;
            final /* synthetic */ AgentCheckoutDirRevisionInfo val$oldInfo;
            {
                this.val$fullCheckout = bl;
                this.val$vcsSettingsHash = string;
                this.val$oldInfo = agentCheckoutDirRevisionInfo;
                if (!this.val$fullCheckout && this.val$vcsSettingsHash.equals(this.val$oldInfo.getVcsSettingsHash())) {
                    this.putAll(this.val$oldInfo.myLastBuilds);
                }
            }
        });
        this.myLastBuilds.put(buildTypeId, buildId);
    }

    public List<VcsRootInstanceState> getInstancesStates() {
        return this.myInstancesStates;
    }

    public String getVcsSettingsHash() {
        return this.myVcsSettingsHash;
    }

    public long getLastBuildByType(@NotNull String buildTypeId) {
        if (buildTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTypeId", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "getLastBuildByType"));
        }
        Long value = this.myLastBuilds.get(buildTypeId);
        return value == null ? 0L : value;
    }

    public long getFirstBuildId() {
        if (this.myLastBuilds.size() > 0) {
            return Collections.min(this.myLastBuilds.values());
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null, _, _ -> null; !null, _, _ -> !null ")
    public VcsRootInstanceState addVcsRootInstanceState(@Nullable String revision, long vcsRootInternalId, @NotNull CheckoutRules checkoutRules) {
        void checkoutRules2;
        if (checkoutRules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "addVcsRootInstanceState"));
        }
        if (revision == null) {
            return null;
        }
        VcsRootInstanceState instanceState = new VcsRootInstanceState(revision, vcsRootInternalId, (CheckoutRules)checkoutRules2);
        this.myInstancesStates.add(instanceState);
        return instanceState;
    }

    public String serializeToXml() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document document = factory.newDocumentBuilder().newDocument();
            Element state = document.createElement("CheckoutDirectoryState");
            document.appendChild(state);
            state.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "VcsSettingsHash", this.getVcsSettingsHash()));
            state.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "CheckoutDirPath", this.getCheckoutDirPath()));
            Element buildHistory = document.createElement("BuildHistory");
            state.appendChild(buildHistory);
            for (Map.Entry<String, Long> entry : this.myLastBuilds.entrySet()) {
                Element build = document.createElement("Build");
                buildHistory.appendChild(build);
                build.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "BuildTypeId", entry.getKey()));
                build.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "BuildId", entry.getValue().toString()));
            }
            Element revisions = document.createElement("VcsRoots");
            state.appendChild(revisions);
            for (VcsRootInstanceState instanceState : this.myInstancesStates) {
                Element revision = document.createElement("VcsRoot");
                revisions.appendChild(revision);
                revision.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "InternalId", String.valueOf(instanceState.getVcsRootInternalId())));
                revision.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "Revision", instanceState.getRevision()));
                revision.appendChild(AgentCheckoutDirRevisionInfo.appendElementWithText(document, "CheckoutRules", instanceState.getCheckoutRules().getAsString()));
            }
            StringWriter stringWriter = new StringWriter();
            XMLSerializer serializer = new XMLSerializer(stringWriter, new OutputFormat());
            serializer.serialize(document);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred during serialization", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "store"));
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
            ByteArrayInputStream is = new ByteArrayInputStream(this.serializeToXml().getBytes());
            StreamUtils.copyThenClose((InputStream)is, (OutputStream)fOut);
        }
        catch (Throwable throwable) {
            FileUtil.close(fOut);
            throw throwable;
        }
        FileUtil.close(fOut);
    }

    @NotNull
    public String getCheckoutDirPath() {
        String string = this.myCheckoutDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo", "getCheckoutDirPath"));
        }
        return string;
    }

    public boolean isEmpty() {
        return this.myInstancesStates.size() == 0;
    }

    public Map<Long, String> createRevisionsMap() {
        HashMap<Long, String> retval = new HashMap<Long, String>();
        for (VcsRootInstanceState instancesState : this.myInstancesStates) {
            retval.put(instancesState.getVcsRootInternalId(), instancesState.getRevision());
        }
        return retval;
    }

    private static Element appendElementWithText(Document document, String elementName, String elementValue) {
        Element element = document.createElement(elementName);
        Text textNode = document.createTextNode(elementValue);
        element.appendChild(textNode);
        return element;
    }

    private static String getStringFromXPath(XPath xPath, String expression, Element element) {
        try {
            return xPath.evaluate(expression, element, XPathConstants.STRING).toString();
        }
        catch (XPathExpressionException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentCheckoutDirRevisionInfo)) {
            return false;
        }
        AgentCheckoutDirRevisionInfo that = (AgentCheckoutDirRevisionInfo)o;
        if (!this.myCheckoutDirPath.equals(that.myCheckoutDirPath)) {
            return false;
        }
        if (!((Object)this.myInstancesStates).equals(that.myInstancesStates)) {
            return false;
        }
        if (!((Object)this.myLastBuilds).equals(that.myLastBuilds)) {
            return false;
        }
        return this.myVcsSettingsHash.equals(that.myVcsSettingsHash);
    }

    public int hashCode() {
        int result = ((Object)this.myInstancesStates).hashCode();
        result = 31 * result + this.myCheckoutDirPath.hashCode();
        result = 31 * result + ((Object)this.myLastBuilds).hashCode();
        result = 31 * result + this.myVcsSettingsHash.hashCode();
        return result;
    }

    public static class VcsRootInstanceState {
        private final long myVcsRootInternalId;
        private final String myRevision;
        private final CheckoutRules myCheckoutRules;

        /*
         * WARNING - void declaration
         */
        public VcsRootInstanceState(@NotNull String revision, long vcsRootInternalId, @NotNull CheckoutRules checkoutRules) {
            void checkoutRules2;
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState", "<init>"));
            }
            if (checkoutRules == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "jetbrains/buildServer/agentServer/AgentCheckoutDirRevisionInfo$VcsRootInstanceState", "<init>"));
            }
            this.myRevision = StringUtil.isEmpty((String)revision) ? null : revision;
            this.myVcsRootInternalId = vcsRootInternalId;
            this.myCheckoutRules = checkoutRules2;
        }

        public long getVcsRootInternalId() {
            return this.myVcsRootInternalId;
        }

        public String getRevision() {
            return this.myRevision;
        }

        public CheckoutRules getCheckoutRules() {
            return this.myCheckoutRules;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VcsRootInstanceState)) {
                return false;
            }
            VcsRootInstanceState that = (VcsRootInstanceState)o;
            if (this.myVcsRootInternalId != that.myVcsRootInternalId) {
                return false;
            }
            if (!this.myCheckoutRules.getAsString().equals(that.myCheckoutRules.getAsString())) {
                return false;
            }
            return this.myRevision.equals(that.myRevision);
        }

        public int hashCode() {
            int result = (int)(this.myVcsRootInternalId ^ this.myVcsRootInternalId >>> 32);
            result = 31 * result + this.myRevision.hashCode();
            result = 31 * result + this.myCheckoutRules.hashCode();
            return result;
        }
    }
}

