/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts;

import java.net.MalformedURLException;
import java.net.URL;
import jetbrains.buildServer.artifacts.DependencyResolverListener;
import org.jetbrains.annotations.NotNull;

public class DependencyResolverContext {
    private DependencyResolverListener myListener;
    private URL myServerUrl;
    private String myPassword;
    private String myUsername;
    private int myConnectionTimeout = 60;

    public void setListener(@NotNull DependencyResolverListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "jetbrains/buildServer/artifacts/DependencyResolverContext", "setListener"));
        }
        this.myListener = listener;
    }

    public void setServerUrl(@NotNull String serverUrl) throws MalformedURLException {
        if (serverUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverUrl", "jetbrains/buildServer/artifacts/DependencyResolverContext", "setServerUrl"));
        }
        this.myServerUrl = new URL(serverUrl);
    }

    public void setCredentials(@NotNull String username, @NotNull String password) {
        if (username == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "username", "jetbrains/buildServer/artifacts/DependencyResolverContext", "setCredentials"));
        }
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "jetbrains/buildServer/artifacts/DependencyResolverContext", "setCredentials"));
        }
        this.myUsername = username;
        this.myPassword = password;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.myConnectionTimeout = connectionTimeout;
    }

    public void checkConfigured() throws IllegalStateException {
        if (this.myServerUrl == null) {
            throw new IllegalStateException("Server URL must be specified");
        }
        if (this.myUsername == null) {
            throw new IllegalStateException("Credentials must be specified");
        }
        if (this.myListener == null) {
            throw new IllegalStateException("Listener must be specified");
        }
    }

    public DependencyResolverListener getListener() {
        return this.myListener;
    }

    public URL getServerUrl() {
        return this.myServerUrl;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public String getUsername() {
        return this.myUsername;
    }

    public int getConnectionTimeout() {
        return this.myConnectionTimeout;
    }
}

