/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.buildServer.log.BindLogger;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.log.ObjectLogger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogBinders {
    private static final Logger LOG = Logger.getLogger((String)LogUtil.class.getName());
    private final Map<Class<?>, ObjectLogger> ourLoggers = new ConcurrentHashMap();
    private static final ObjectLogger LOGGABLE_INSTANCE = new ObjectLogger(){

        @NotNull
        public String describe(@NotNull Object object, @NotNull ObjectLogger.Verbosity verbosity) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "jetbrains/buildServer/log/LogBinders$1", "describe"));
            }
            if (verbosity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verbosity", "jetbrains/buildServer/log/LogBinders$1", "describe"));
            }
            Loggable l = (Loggable)object;
            String string = l.describe(verbosity != ObjectLogger.Verbosity.NORMAL);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders$1", "describe"));
            }
            return string;
        }
    };
    private static final ObjectLogger TO_STRING_INSTANCE = new ObjectLogger(){

        @NotNull
        public String describe(@NotNull Object object, @NotNull ObjectLogger.Verbosity verbosity) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "jetbrains/buildServer/log/LogBinders$2", "describe"));
            }
            if (verbosity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verbosity", "jetbrains/buildServer/log/LogBinders$2", "describe"));
            }
            String string = object.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders$2", "describe"));
            }
            return string;
        }
    };

    @NotNull
    public ObjectLogger findLogger(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/log/LogBinders", "findLogger"));
        }
        ObjectLogger cached = this.getCachedLogger(clazz);
        if (cached != null) {
            ObjectLogger objectLogger = cached;
            if (objectLogger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders", "findLogger"));
            }
            return objectLogger;
        }
        ObjectLogger objectLogger = this.findAnnotation(clazz);
        if (objectLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders", "findLogger"));
        }
        return objectLogger;
    }

    @Nullable
    public ObjectLogger getCachedLogger(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/log/LogBinders", "getCachedLogger"));
        }
        return this.ourLoggers.get(clazz);
    }

    @Nullable
    private ObjectLogger forType(@NotNull Class<?> clazz) {
        ObjectLogger logger;
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/log/LogBinders", "forType"));
        }
        BindLogger annotation = clazz.getAnnotation(BindLogger.class);
        if (annotation == null) {
            return null;
        }
        Class<? extends ObjectLogger> loggerType = annotation.value();
        try {
            Constructor<? extends ObjectLogger> constructor = loggerType.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            logger = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create");
            return TO_STRING_INSTANCE;
        }
        this.ourLoggers.put(clazz, logger);
        return logger;
    }

    @NotNull
    private ObjectLogger defaultLogger(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/log/LogBinders", "defaultLogger"));
        }
        if (Loggable.class.isAssignableFrom(clazz)) {
            ObjectLogger objectLogger = LOGGABLE_INSTANCE;
            if (objectLogger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders", "defaultLogger"));
            }
            return objectLogger;
        }
        ObjectLogger objectLogger = TO_STRING_INSTANCE;
        if (objectLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders", "defaultLogger"));
        }
        return objectLogger;
    }

    @NotNull
    private ObjectLogger findAnnotation(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/log/LogBinders", "findAnnotation"));
        }
        LinkedHashSet<Class> visitedTypes = new LinkedHashSet<Class>();
        ArrayDeque queue = new ArrayDeque();
        queue.add(clazz);
        ObjectLogger logger = null;
        while (!queue.isEmpty()) {
            Class cl = (Class)queue.remove();
            if (!visitedTypes.add(cl)) continue;
            logger = this.forType(cl);
            if (logger != null) break;
            Class parent = cl.getSuperclass();
            if (parent != null) {
                queue.add(parent);
            }
            Collections.addAll(queue, cl.getInterfaces());
        }
        if (logger == null) {
            logger = this.defaultLogger(clazz);
        }
        for (Class visitedType : visitedTypes) {
            this.ourLoggers.put(visitedType, logger);
        }
        ObjectLogger objectLogger = logger;
        if (objectLogger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogBinders", "findAnnotation"));
        }
        return objectLogger;
    }
}

