/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import jetbrains.buildServer.log.LogInitializationException;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogInitializer {
    private static boolean ourInitialized;
    @NonNls
    public static final String LOG4J_CONFIGURATION = "log4j.configuration";
    @NonNls
    public static final String TEAMCITY_LOGS_DIR_PROP = "teamcity_logs";
    @NonNls
    private static final String DEFAULT_LOGS_DIR_PATH = "../logs/";
    @NonNls
    public static final String TEAMCITY_SERVER_LOG4J_XML = "teamcity-server-log4j.xml";
    @NonNls
    public static final String TEAMCITY_AGENT_LOG4J_XML = "teamcity-agent-log4j.xml";
    public static final String MAIN_CATEGORY = "jetbrains.buildServer";
    private static final String MAIN_FILE_NAME = "teamcity-server.log";
    @Nullable
    private static File ourLogDir;
    @Nullable
    private static LogInitializationException ourInitializationException;

    public static void initServerLogging() {
        if (ourInitialized) {
            return;
        }
        LogConfigurator logConfigurator = LogInitializer.propertyConfigurator(true);
        LogConfigurator resourceConfigurator = LogInitializer.resourceConfigurator(TEAMCITY_SERVER_LOG4J_XML);
        LogInitializer.init(logConfigurator, resourceConfigurator);
        ourInitialized = true;
        Loggers.STARTUP.info("\n\n\n\n\n\n");
        Loggers.STARTUP.info("===========================================================");
        Loggers.STARTUP.info("Starting TeamCity server");
    }

    public static void initAgentLogging() {
        if (ourInitialized) {
            return;
        }
        LogInitializer.init(LogInitializer.propertyConfigurator(true), LogInitializer.resourceConfigurator(TEAMCITY_AGENT_LOG4J_XML));
        ourInitialized = true;
        Loggers.SERVER.info("Starting TeamCity agent");
    }

    public static void init(LogConfigurator ... configurators) {
        if (configurators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurators", "jetbrains/buildServer/log/LogInitializer", "init"));
        }
        try {
            LogInitializer.initLogDir();
            for (LogConfigurator conf : configurators) {
                if (!conf.configure()) continue;
                return;
            }
        }
        catch (LogInitializationException lie) {
            LogInitializer.writeToStdError("Could not initialize logging directory. Logging into the standard console output.");
            LogInitializer.removeAllAppenders();
            LogInitializer.addConsoleAppender();
        }
    }

    public static LogConfigurator fileConfigurator(final @NotNull File file, final boolean watchForChanges) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/log/LogInitializer", "fileConfigurator"));
        }
        return new LogConfigurator(){

            public boolean configure() {
                if (!file.isFile()) {
                    return false;
                }
                LogInitializer.configureFromFile(file, watchForChanges);
                return true;
            }
        };
    }

    public static void reconfigureFromFile(@NotNull File configFile, @NotNull File logDir, boolean trackChanges) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "jetbrains/buildServer/log/LogInitializer", "reconfigureFromFile"));
        }
        if (logDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDir", "jetbrains/buildServer/log/LogInitializer", "reconfigureFromFile"));
        }
        File resolvedConfigFile = LogInitializer.resolvePathSafely(configFile);
        if (!resolvedConfigFile.isFile()) {
            throw new IllegalArgumentException("Logging configuration file \"" + resolvedConfigFile + "\" not found");
        }
        File resolvedLogDir = LogInitializer.resolvePathSafely(configFile);
        resolvedLogDir.mkdirs();
        boolean dirIsOk = LogInitializer.checkDirectoryIsWritable(resolvedConfigFile);
        if (!dirIsOk) {
            throw new IllegalArgumentException("Logging directory \"" + resolvedLogDir + "\" is not writable");
        }
        LogInitializer.removeAllAppenders();
        LogManager.resetConfiguration();
        LogInitializer.setupLogsDirectoryProperty(resolvedLogDir);
        LogInitializer.configureFromFile(resolvedConfigFile, trackChanges);
    }

    private static void configureFromFile(@NotNull File file, boolean trackChanges) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/log/LogInitializer", "configureFromFile"));
        }
        if (trackChanges) {
            int secs = 10;
            DOMConfigurator.configureAndWatch((String)file.getAbsolutePath(), (long)10000L);
            System.out.println("Log4J configuration file " + file.getAbsolutePath() + " will be monitored with interval " + 10 + " seconds.");
        } else {
            DOMConfigurator.configure((String)file.getAbsolutePath());
        }
    }

    public static LogConfigurator resourceConfigurator(final String ... resources) {
        if (resources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "jetbrains/buildServer/log/LogInitializer", "resourceConfigurator"));
        }
        return new LogConfigurator(){

            public boolean configure() {
                boolean configured = false;
                for (String res : resources) {
                    URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(res);
                    if (resourceUrl == null) continue;
                    DOMConfigurator.configure((URL)resourceUrl);
                    configured = true;
                }
                return configured;
            }
        };
    }

    public static LogConfigurator propertyConfigurator(final boolean watchForFileChanges) {
        return new LogConfigurator(){

            public boolean configure() {
                String log4jUrl = TeamCityProperties.getPropertyOrNull(LogInitializer.LOG4J_CONFIGURATION);
                if (log4jUrl == null) {
                    return false;
                }
                try {
                    URL url = new URL(log4jUrl);
                    File file = new File(url.getPath());
                    if (!file.isFile()) {
                        LogInitializer.writeToStdError("Specified log4j configuration file (" + log4jUrl + ") not found.");
                        System.setProperty(LogInitializer.LOG4J_CONFIGURATION, "");
                        return false;
                    }
                    if (!LogInitializer.checkTeamCityLog4jConfig(file)) {
                        LogInitializer.writeToStdError("Specified log4j configuration file (" + log4jUrl + ") does not have TeamCity categories, file skipped.");
                        return false;
                    }
                    return LogInitializer.fileConfigurator(file, watchForFileChanges).configure();
                }
                catch (MalformedURLException e) {
                    File file = new File(log4jUrl);
                    if (file.isFile()) {
                        return LogInitializer.fileConfigurator(file, watchForFileChanges).configure();
                    }
                    LogInitializer.writeToStdError("Specified log4j configuration file (" + log4jUrl + ") not found.");
                    return false;
                }
            }
        };
    }

    private static boolean checkTeamCityLog4jConfig(File file) {
        try {
            String configTxt = new String(LogInitializer.loadTextFile(file));
            return configTxt.indexOf(MAIN_CATEGORY) != -1;
        }
        catch (IOException e) {
            LogInitializer.writeToStdError("Failed to load log4j configuration file: " + file + ", error: " + e.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] loadTextFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/log/LogInitializer", "loadTextFile"));
        }
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(stream);
        try {
            char[] cArray = FileUtil.loadText((Reader)reader, (int)((int)file.length()));
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private static void writeToStdError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/log/LogInitializer", "writeToStdError"));
        }
        System.err.println(text);
    }

    private static void writeToStdOut(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/log/LogInitializer", "writeToStdOut"));
        }
        System.out.println(text);
    }

    private static void setupLogsDirectoryProperty(@NotNull File logsDirectory) {
        String logPath;
        if (logsDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logsDirectory", "jetbrains/buildServer/log/LogInitializer", "setupLogsDirectoryProperty"));
        }
        if (ourLogDir == null || !ourLogDir.equals(logsDirectory)) {
            ourLogDir = logsDirectory;
            LogInitializer.writeToStdOut("Using logs directory " + logsDirectory.getAbsolutePath());
        }
        if (!(logPath = ourLogDir.getAbsolutePath()).endsWith(File.separator)) {
            logPath = logPath + File.separator;
        }
        System.setProperty(TEAMCITY_LOGS_DIR_PROP, logPath);
    }

    @NotNull
    public static File getLogDir() throws LogInitializationException {
        if (ourLogDir == null) {
            if (ourInitializationException == null) {
                LogInitializer.initLogDir();
            } else {
                throw new LogInitializationException(ourInitializationException);
            }
        }
        assert (ourLogDir != null);
        File file = ourLogDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogInitializer", "getLogDir"));
        }
        return file;
    }

    private static void initLogDir() throws LogInitializationException {
        LinkedList<File> checkedDirs = new LinkedList<File>();
        String logsProperty = TeamCityProperties.getProperty(TEAMCITY_LOGS_DIR_PROP, DEFAULT_LOGS_DIR_PATH);
        File logsDirectory = LogInitializer.resolvePathSafely(new File(logsProperty));
        boolean logsDirIsOK = LogInitializer.tryToUseLogsDirectory(logsDirectory, "logs directory");
        if (!logsDirIsOK) {
            checkedDirs.add(logsDirectory);
            ourInitializationException = new LogInitializationException(checkedDirs);
            throw ourInitializationException;
        }
        LogInitializer.setupLogsDirectoryProperty(logsDirectory);
    }

    @NotNull
    private static File resolvePathSafely(@NotNull File file) {
        File file2;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "jetbrains/buildServer/log/LogInitializer", "resolvePathSafely"));
        }
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            File file3 = file;
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogInitializer", "resolvePathSafely"));
            }
            return file3;
        }
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogInitializer", "resolvePathSafely"));
        }
        return file2;
    }

    private static boolean tryToUseLogsDirectory(File logsDirectory, String dirDescriptionInfix) {
        logsDirectory.mkdirs();
        if (!logsDirectory.isDirectory()) {
            LogInitializer.writeToStdError("Failed to create the " + dirDescriptionInfix + " " + LogInitializer.getCanonicalFile(logsDirectory));
            return false;
        }
        if (!LogInitializer.checkDirectoryIsWritable(logsDirectory)) {
            LogInitializer.writeToStdError("The " + dirDescriptionInfix + " " + LogInitializer.getCanonicalFile(logsDirectory) + " is not writable.");
            return false;
        }
        File serverLogFile = new File(logsDirectory, MAIN_FILE_NAME);
        if (serverLogFile.exists() && !serverLogFile.canWrite()) {
            LogInitializer.writeToStdError("The file " + LogInitializer.getCanonicalFile(serverLogFile) + " is not writable.");
            return false;
        }
        return true;
    }

    private static File getCanonicalFile(File logsDirectory) {
        try {
            return logsDirectory.getCanonicalFile();
        }
        catch (Throwable e) {
            return logsDirectory.getAbsoluteFile();
        }
    }

    private static boolean checkDirectoryIsWritable(File dir) {
        try {
            boolean deleted;
            File testFile = new File(dir, "testfile.txt");
            if (testFile.exists() && !(deleted = testFile.delete()) && testFile.exists()) {
                return false;
            }
            LogInitializer.writeFileAndReportErrorSafe(testFile, "This file was created just to ensure that the directory is writable.\nNo problem to delete this file.\n");
            boolean ok = testFile.exists() && testFile.isFile();
            boolean deleted2 = testFile.delete();
            return ok && deleted2;
        }
        catch (IOException ioe) {
            return false;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFileAndReportErrorSafe(@NotNull File testFile, @NotNull String text) throws IOException {
        if (testFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFile", "jetbrains/buildServer/log/LogInitializer", "writeFileAndReportErrorSafe"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "jetbrains/buildServer/log/LogInitializer", "writeFileAndReportErrorSafe"));
        }
        FileWriter fileWriter = new FileWriter(testFile);
        try {
            fileWriter.write(text);
        }
        finally {
            fileWriter.close();
        }
    }

    public static boolean isUnitTest() {
        return "yes".equals(System.getProperty("jetbrains.unit.test"));
    }

    public static void setUnitTest(boolean enable) {
        if (enable) {
            System.setProperty("jetbrains.unit.test", "yes");
            LogInitializer.init(LogInitializer.resourceConfigurator("teamcity-tests-log4j.xml"));
            ourInitialized = true;
        } else {
            System.setProperty("jetbrains.unit.test", "no");
        }
    }

    public static void addConsoleAppender() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.addAppender((Appender)LogInitializer.createConsoleAppender());
        }
        Logger.getLogger((String)"jetbrains.buildServer.buildTriggers.vcs").setAdditivity(false);
    }

    public static void removeAllAppenders() {
        for (Logger logger : LogInitializer.debugLoggers()) {
            logger.removeAllAppenders();
        }
    }

    private static Logger[] debugLoggers() {
        return new Logger[]{Logger.getRootLogger(), Logger.getLogger((String)"jetbrains.buildServer.buildTriggers.vcs"), Logger.getLogger((String)"jetbrains.buildServer.VCS")};
    }

    public static ConsoleAppender createConsoleAppender() {
        return new ConsoleAppender((Layout)new PatternLayout("[%d{ABSOLUTE}] %6p - %20.20c [%t] %m \n"));
    }

    @Deprecated
    public static void enableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.DEBUG);
        Loggers.VCS.setLevel(Level.DEBUG);
    }

    @Deprecated
    public static void disableDebug() {
        Logger.getLogger((String)MAIN_CATEGORY).setLevel(Level.INFO);
        Loggers.VCS.setLevel(Level.INFO);
    }

    public static interface LogConfigurator {
        public boolean configure();
    }
}

