/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.log;

import jetbrains.buildServer.log.LogBinders;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.log.ObjectLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogUtil {
    private static final String NULL_OBJECT = "<null>";
    private static final LogBinders ourBinders = new LogBinders();

    @NotNull
    public static String quote(@Nullable String text) {
        String string = "\"" + (text != null ? text : NULL_OBJECT) + "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "quote"));
        }
        return string;
    }

    @NotNull
    public static String describe(@Nullable Loggable loggable) {
        if (loggable == null) {
            if (NULL_OBJECT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "describe"));
            }
            return NULL_OBJECT;
        }
        String description = loggable.describe(false);
        if (description == null) {
            if (NULL_OBJECT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "describe"));
            }
            return NULL_OBJECT;
        }
        String string = description;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "describe"));
        }
        return string;
    }

    @NotNull
    public static String describe(@Nullable Object o) {
        if (o == null) {
            if (NULL_OBJECT == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "describe"));
            }
            return NULL_OBJECT;
        }
        String string = ourBinders.findLogger(o.getClass()).describe(o, ObjectLogger.Verbosity.NORMAL);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/log/LogUtil", "describe"));
        }
        return string;
    }
}

