/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.ContextVariables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HidingContextVariables
implements ContextVariables {
    @NotNull
    private final ContextVariables myProvider;
    @Nullable
    private Collection<String> myAllowedNames;

    public HidingContextVariables(@NotNull ContextVariables provider, @Nullable Collection<String> allowedNames) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "jetbrains/buildServer/parameters/impl/HidingContextVariables", "<init>"));
        }
        this.myProvider = provider;
        this.myAllowedNames = allowedNames;
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/parameters/impl/HidingContextVariables", "get"));
        }
        if (this.myAllowedNames == null || this.myAllowedNames.contains(name)) {
            return this.myProvider.get(name);
        }
        return null;
    }

    @Override
    public int size() {
        if (this.myAllowedNames == null) {
            return this.myProvider.size();
        }
        return this.getAll().size();
    }

    @Override
    @NotNull
    public Map<String, Object> getAll() {
        if (this.myAllowedNames == null) {
            Map<String, Object> map = this.myProvider.getAll();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/HidingContextVariables", "getAll"));
            }
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (this.myAllowedNames != null);
        for (String name : this.myAllowedNames) {
            Object value = this.myProvider.get(name);
            if (value == null) continue;
            result.put(name, value);
        }
        HashMap<String, Object> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/HidingContextVariables", "getAll"));
        }
        return hashMap;
    }

    public void setAllowedNames(@Nullable Collection<String> allowedNames) {
        this.myAllowedNames = allowedNames;
    }
}

