/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParametersProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyCopyMapParametersProvider
implements MapParametersProvider {
    private final ParametersProvider mySource;
    private final MapParametersProvider myDestination;
    private boolean myCopied;

    LazyCopyMapParametersProvider(@NotNull ParametersProvider source, @NotNull MapParametersProvider destination) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "<init>"));
        }
        if (destination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "<init>"));
        }
        this.mySource = source;
        this.myDestination = destination;
    }

    @Override
    public void put(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "put"));
        }
        this.copy();
        this.myDestination.put(key, value);
    }

    @Override
    @Nullable
    public String remove(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "remove"));
        }
        this.copy();
        return this.myDestination.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<String, String> fromMap) {
        if (fromMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromMap", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "putAll"));
        }
        this.copy();
        this.myDestination.putAll(fromMap);
    }

    @Override
    @Nullable
    public String get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/LazyCopyMapParametersProvider", "get"));
        }
        return this.myCopied ? this.myDestination.get(key) : this.mySource.get(key);
    }

    @Override
    public int size() {
        this.copy();
        return this.myDestination.size();
    }

    @Override
    public Map<String, String> getAll() {
        this.copy();
        return this.myDestination.getAll();
    }

    private void copy() {
        if (this.myCopied) {
            return;
        }
        this.myDestination.putAll(this.mySource.getAll());
        this.myCopied = true;
    }
}

