/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.parameters.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jetbrains.buildServer.parameters.MapParametersProvider;
import jetbrains.buildServer.parameters.ParameterResolver;
import jetbrains.buildServer.parameters.ParametersProvider;
import jetbrains.buildServer.parameters.ProcessingResult;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.parameters.impl.CompositeParametersProviderImpl;
import jetbrains.buildServer.parameters.impl.LazyCopyMapParametersProvider;
import jetbrains.buildServer.parameters.impl.ProcessingResultImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParametersInOut {
    private final String myName;
    private final MapParametersProvider myPartlyResolved;
    private final MapParametersProvider myFullyResolved;
    private final MapParametersProvider myUnresolved;
    private final ParametersProvider myNotFullyResolved;

    public ParametersInOut(@NotNull String name, @NotNull ParametersProvider original, @NotNull jetbrains.buildServer.parameters.impl.ParametersProviderFactory factory) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "jetbrains/buildServer/parameters/impl/ParametersInOut", "<init>"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "jetbrains/buildServer/parameters/impl/ParametersInOut", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "jetbrains/buildServer/parameters/impl/ParametersInOut", "<init>"));
        }
        this.myName = name;
        this.myPartlyResolved = factory.getParametersProvider();
        this.myFullyResolved = factory.getParametersProvider();
        this.myUnresolved = new LazyCopyMapParametersProvider(original, factory.getParametersProvider());
        CompositeParametersProviderImpl notFullyResolved = new CompositeParametersProviderImpl();
        notFullyResolved.appendParametersProvider(this.myPartlyResolved);
        notFullyResolved.appendParametersProvider(this.myUnresolved);
        this.myNotFullyResolved = notFullyResolved;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public ParametersProvider getUnresolved() {
        MapParametersProvider mapParametersProvider = this.myUnresolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "getUnresolved"));
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getFullyResolved() {
        MapParametersProvider mapParametersProvider = this.myFullyResolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "getFullyResolved"));
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getPartlyResolved() {
        MapParametersProvider mapParametersProvider = this.myPartlyResolved;
        if (mapParametersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "getPartlyResolved"));
        }
        return mapParametersProvider;
    }

    @NotNull
    public ParametersProvider getNotFullyResolved() {
        ParametersProvider parametersProvider = this.myNotFullyResolved;
        if (parametersProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "getNotFullyResolved"));
        }
        return parametersProvider;
    }

    int resolveParametersInSinglePass(@NotNull ParametersProvider dictionary, @NotNull ParameterResolver processor, @Nullable StopPredicate stop) {
        if (dictionary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "jetbrains/buildServer/parameters/impl/ParametersInOut", "resolveParametersInSinglePass"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "jetbrains/buildServer/parameters/impl/ParametersInOut", "resolveParametersInSinglePass"));
        }
        int resolvedCount = 0;
        for (Map.Entry<String, String> parameter : this.getNotFullyResolved().getAll().entrySet()) {
            String key = parameter.getKey();
            String value = parameter.getValue();
            assert (key != null) : "Parameter has null key. Value='" + value + "'";
            assert (value != null) : "Parameter with key='" + key + "'has null value.";
            ProcessingResult evalResult = processor.resolve(key, value, dictionary);
            if (evalResult.isFullyResolved()) {
                this.markAsFullyResolved(key, evalResult.getResult());
                ++resolvedCount;
                if (stop == null || !stop.call()) continue;
                break;
            }
            if (!evalResult.isModified()) continue;
            this.markAsPartlyResolved(key, evalResult.getResult());
        }
        return resolvedCount;
    }

    void resolvingFinished() {
        for (MapParametersProvider provider : Arrays.asList(this.myFullyResolved, this.myPartlyResolved, this.myUnresolved)) {
            HashMap<String, String> allParams = new HashMap<String, String>(provider.getAll());
            for (Map.Entry entry : allParams.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null) continue;
                entry.setValue(ReferencesResolverUtil.unescape(value));
            }
            provider.putAll(allParams);
        }
    }

    public void markAsFullyResolved(@NotNull String key, @NotNull String resolvedValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/ParametersInOut", "markAsFullyResolved"));
        }
        if (resolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedValue", "jetbrains/buildServer/parameters/impl/ParametersInOut", "markAsFullyResolved"));
        }
        this.myFullyResolved.put(key, resolvedValue);
        this.myUnresolved.remove(key);
        this.myPartlyResolved.remove(key);
    }

    public void markAsPartlyResolved(@NotNull String key, @NotNull String partlyResolvedValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/ParametersInOut", "markAsPartlyResolved"));
        }
        if (partlyResolvedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partlyResolvedValue", "jetbrains/buildServer/parameters/impl/ParametersInOut", "markAsPartlyResolved"));
        }
        this.myPartlyResolved.put(key, partlyResolvedValue);
        this.myUnresolved.remove(key);
    }

    @NotNull
    public ParametersProvider getAllParameters() {
        CompositeParametersProviderImpl result = new CompositeParametersProviderImpl();
        result.appendParametersProvider(this.myFullyResolved);
        result.appendParametersProvider(this.myPartlyResolved);
        result.appendParametersProvider(this.myUnresolved);
        CompositeParametersProviderImpl compositeParametersProviderImpl = result;
        if (compositeParametersProviderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "getAllParameters"));
        }
        return compositeParametersProviderImpl;
    }

    @NotNull
    public ProcessingResult createProcessingResult(@NotNull String key, @NotNull String origValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "jetbrains/buildServer/parameters/impl/ParametersInOut", "createProcessingResult"));
        }
        if (origValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origValue", "jetbrains/buildServer/parameters/impl/ParametersInOut", "createProcessingResult"));
        }
        String resultValue = this.myFullyResolved.get(key);
        if (resultValue == null) {
            String partlyResolved = this.myPartlyResolved.get(key);
            if (partlyResolved == null) {
                partlyResolved = this.myUnresolved.get(key);
            }
            assert (partlyResolved != null);
            ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(partlyResolved, !origValue.equals(partlyResolved), false);
            if (processingResultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "createProcessingResult"));
            }
            return processingResultImpl;
        }
        ProcessingResultImpl processingResultImpl = new ProcessingResultImpl(resultValue, !origValue.equals(resultValue), true);
        if (processingResultImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/parameters/impl/ParametersInOut", "createProcessingResult"));
        }
        return processingResultImpl;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("name: ").append(this.getName()).append(",  ");
        result.append("unresolved: ").append(this.getNotFullyResolved()).append(",  ");
        result.append("partly resolved: ").append(this.getPartlyResolved());
        result.append("fully resolved: ").append(this.getFullyResolved());
        return result.toString();
    }

    static interface StopPredicate {
        public boolean call();
    }

    @Deprecated
    public static interface ParametersProviderFactory
    extends jetbrains.buildServer.parameters.impl.ParametersProviderFactory {
    }
}

