/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.runner;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineArgumentsUtil {
    @NotNull
    public static List<String> getRunnerArgs(@NotNull Map<String, String> runnerParameters) {
        if (runnerParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnerParameters", "jetbrains/buildServer/runner/CommandLineArgumentsUtil", "getRunnerArgs"));
        }
        String userDefinedArguments = runnerParameters.get("runnerArgs");
        if (userDefinedArguments == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/runner/CommandLineArgumentsUtil", "getRunnerArgs"));
            }
            return list;
        }
        List<String> list = CommandLineArgumentsUtil.extractArguments(userDefinedArguments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/runner/CommandLineArgumentsUtil", "getRunnerArgs"));
        }
        return list;
    }

    @NotNull
    public static List<String> extractArguments(@NotNull String userDefinedArguments) {
        if (userDefinedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDefinedArguments", "jetbrains/buildServer/runner/CommandLineArgumentsUtil", "extractArguments"));
        }
        List<String> list = StringUtil.splitCommandArgumentsAndUnquote(userDefinedArguments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/runner/CommandLineArgumentsUtil", "extractArguments"));
        }
        return list;
    }
}

