/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jetbrains.buildServer.configuration.ChangeListener;
import jetbrains.buildServer.configuration.FileWatcher;
import jetbrains.buildServer.serverSide.BasePropertiesModel;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWatchingPropertiesModel
extends BasePropertiesModel {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "internal.properties";
    private volatile Map<String, String> ourProperties;
    private final File myPropertiesFile;
    private final FileWatcher ourFileWatcher;

    public FileWatchingPropertiesModel(@NotNull File propertiesFile) {
        if (propertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFile", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "<init>"));
        }
        this.ourProperties = new HashMap<String, String>();
        this.myPropertiesFile = propertiesFile;
        this.ourFileWatcher = new FileWatcher(this.myPropertiesFile);
        this.ourFileWatcher.registerListener(new ChangeListener(){

            public void changeOccured(String requestor) {
                FileWatchingPropertiesModel.this.readAndUpdateProperties();
            }
        });
        this.readAndUpdateProperties();
        this.setFileWatcherSleepingPeriod(this.getCurrentSleepingInterval());
    }

    @Override
    @NotNull
    public Map<String, String> getUserDefinedProperties() {
        Map<String, String> map = this.ourProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "getUserDefinedProperties"));
        }
        return map;
    }

    private long getCurrentSleepingInterval() {
        int defaultValue = 10000;
        String result = this.getPropertyOrNull("teamcity.internal.properties.reread.interval.ms");
        try {
            if (StringUtil.isEmptyOrSpaces((String)result)) {
                return 10000L;
            }
            long value = Long.parseLong(result);
            if (value < 0L) {
                return 10000L;
            }
            return value;
        }
        catch (Exception e) {
            return 10000L;
        }
    }

    @Nullable
    public FileWatcher getFileWatcher() {
        return this.ourFileWatcher;
    }

    public void setFileWatcherSleepingPeriod(long currentSleepingInterval) {
        this.ourFileWatcher.setSleepingPeriod(currentSleepingInterval);
    }

    public synchronized void stopFileWatching() {
        this.ourFileWatcher.stop();
    }

    public synchronized void startFileWatching() {
        this.ourFileWatcher.start();
    }

    public void forceReloadProperties() {
        this.readAndUpdateProperties();
    }

    @NotNull
    public File getWatchingFilePath() {
        File file = this.myPropertiesFile.getAbsoluteFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "getWatchingFilePath"));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<String, String> readAndUpdateProperties() {
        block24: {
            Map<String, String> map;
            InputStream input;
            block26: {
                Map map2;
                block25: {
                    input = null;
                    try {
                        if (!this.myPropertiesFile.exists()) break block24;
                        Properties properties = new Properties();
                        input = new BufferedInputStream(new FileInputStream(this.myPropertiesFile));
                        properties.load(input);
                        if (properties.isEmpty()) {
                            if (this.myPropertiesFile.length() == 0L) {
                                Map map3 = EMPTY_PROPERTIES;
                                map2 = map3;
                                break block25;
                            }
                            String text = "";
                            int attempt = 0;
                            while (text.isEmpty() && ++attempt < 3) {
                                text = FileUtil.readText(this.myPropertiesFile);
                            }
                            properties.load(new StringReader(text));
                        }
                        Map<String, String> map4 = FileWatchingPropertiesModel.propertiesToMap(properties);
                        this.ourProperties = map4;
                        long interval = this.getCurrentSleepingInterval();
                        FileWatcher fileWatcher = this.ourFileWatcher;
                        if (fileWatcher != null && fileWatcher.getSleepingPeriod() != interval) {
                            fileWatcher.setSleepingPeriod(interval);
                        }
                        map = map4;
                        break block26;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to read " + this.myPropertiesFile + " file: " + e.getMessage());
                        break block24;
                    }
                }
                if (map2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "readAndUpdateProperties"));
                }
                return map2;
            }
            Map<String, String> map5 = map;
            if (map5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "readAndUpdateProperties"));
            }
            return map5;
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        Map map = EMPTY_PROPERTIES;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/FileWatchingPropertiesModel", "readAndUpdateProperties"));
        }
        return map;
    }
}

