/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.serverSide;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamCityServerProperties {
    public static final String TEAMCITY_DATA_PATH_PROPERTY = "teamcity.data.path";
    public static final String TEAMCITY_DATA_PATH_ENV = "TEAMCITY_DATA_PATH";
    public static final String TEAMCITY_DEBUG_MODE = "teamcity.development.mode";

    @NotNull
    public static File determineDataDir(@Nullable Logger logger) {
        String userHome;
        String envName;
        String envValue;
        File dataDir = null;
        String determineSource = null;
        String propName = TEAMCITY_DATA_PATH_PROPERTY;
        String propValue = System.getProperty(propName);
        if (propValue != null) {
            dataDir = new File(propValue);
            determineSource = "JVM property " + propName;
        }
        if (dataDir == null && (envValue = System.getenv(envName = TEAMCITY_DATA_PATH_ENV)) != null) {
            dataDir = new File(envValue);
            determineSource = "environment variable " + envName;
        }
        if (dataDir == null && (userHome = System.getProperty("user.home")) != null) {
            dataDir = new File(userHome, ".BuildServer");
            determineSource = "user home directory";
        }
        if (dataDir == null) {
            dataDir = new File("/BuildServer");
            determineSource = "root of the file system, because neither JVM property nor environment variable nor user home directory were defined";
        }
        if (logger != null) {
            logger.info("TeamCity Data Directory path is determined using the " + determineSource);
        }
        File file = dataDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/TeamCityServerProperties", "determineDataDir"));
        }
        return file;
    }

    @NotNull
    public static String getDataPath() {
        String dataPath = TeamCityServerProperties.determineDataDir(null).getAbsolutePath().replace(File.separatorChar, '/');
        if (!dataPath.endsWith("/")) {
            dataPath = dataPath + "/";
        }
        String string = dataPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/serverSide/TeamCityServerProperties", "getDataPath"));
        }
        return string;
    }
}

