/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ChildSpringContextLoader
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private String[] myConfigLocations;
    private ApplicationContext myParentContext;
    private AbstractApplicationContext myContext;

    public void setConfigLocations(String ... configLocations) {
        this.myConfigLocations = configLocations;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.myParentContext = context;
    }

    public void afterPropertiesSet() throws Exception {
        this.myContext = new ClassPathXmlApplicationContext(this.myConfigLocations, false, this.myParentContext){

            protected DefaultListableBeanFactory createBeanFactory() {
                DefaultListableBeanFactory factory = super.createBeanFactory();
                factory.setBeanClassLoader(ChildSpringContextLoader.this.myParentContext.getClassLoader());
                return factory;
            }
        };
        this.myContext.setClassLoader(this.myParentContext.getClassLoader());
        this.myContext.refresh();
    }

    public void destroy() throws Exception {
        if (this.myContext != null) {
            this.myContext.destroy();
        }
    }
}

