/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsUtil {
    public static final Filter ACCEPT_ALL = new Filter(){

        public boolean accept(@NotNull Object data) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/CollectionsUtil$1", "accept"));
            }
            return true;
        }
    };
    public static final Converter SAME = new Converter(){

        public Object createFrom(@NotNull Object source) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/CollectionsUtil$2", "createFrom"));
            }
            return source;
        }
    };

    @NotNull
    public static <T> Filter<T> acceptAllFilter() {
        Filter filter = ACCEPT_ALL;
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "acceptAllFilter"));
        }
        return filter;
    }

    private CollectionsUtil() {
    }

    @NotNull
    public static <T> Set<T> flatten(@NotNull Collection<Pair<T, T>> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/CollectionsUtil", "flatten"));
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Pair<T, T> pair : data) {
            set.add(pair.first);
            set.add(pair.second);
        }
        HashSet<Object> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "flatten"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> Set<T> flatten(@NotNull Map<T, T> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/CollectionsUtil", "flatten"));
        }
        HashSet<T> set = new HashSet<T>();
        set.addAll(data.keySet());
        set.addAll(data.values());
        HashSet<T> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "flatten"));
        }
        return hashSet;
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Collection<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.filterAndConvertCollection(iterable, converter, filter);
    }

    public static <ResultType, SourceType> List<ResultType> filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        ArrayList result = CollectionsUtil.filterAndConvertCollection(source, new ArrayList(), converter, filter);
        return result == null ? null : Collections.unmodifiableList(result);
    }

    public static <ResultType, ResultCollection extends Collection<ResultType>, SourceType> ResultCollection filterAndConvertCollection(Iterable<? extends SourceType> source, @NotNull ResultCollection collection, @NotNull Converter<ResultType, SourceType> converter, @NotNull Filter<SourceType> filter) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/CollectionsUtil", "filterAndConvertCollection"));
        }
        if (source == null) {
            return null;
        }
        if (source != null) {
            for (SourceType o : source) {
                if (!filter.accept(o)) continue;
                Object newO = null;
                if (o != null) {
                    newO = converter.createFrom(o);
                }
                collection.add(newO);
            }
        }
        return collection;
    }

    public static <T> Collection<T> join(Collection<T> ... a) {
        int size = 0;
        for (Collection<T> collection : a) {
            size += collection.size();
        }
        ArrayList<T> union = new ArrayList<T>(size);
        for (Collection<T> collection : a) {
            union.addAll(collection);
        }
        return union;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "jetbrains/buildServer/util/CollectionsUtil", "join"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "jetbrains/buildServer/util/CollectionsUtil", "join"));
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size());
        list.addAll(a);
        list.addAll(b);
        return list;
    }

    public static <T> Collection<T> join(@NotNull Collection<T> a, @NotNull Collection<T> b, @NotNull Collection<T> c) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "jetbrains/buildServer/util/CollectionsUtil", "join"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "jetbrains/buildServer/util/CollectionsUtil", "join"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "jetbrains/buildServer/util/CollectionsUtil", "join"));
        }
        ArrayList<T> list = new ArrayList<T>(a.size() + b.size() + c.size());
        list.addAll(a);
        list.addAll(b);
        list.addAll(c);
        return list;
    }

    public static <SourceType> List<SourceType> filterCollection(Collection<? extends SourceType> source, Filter<SourceType> filter) {
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.filterCollection(iterable, filter);
    }

    public static <SourceType> List<SourceType> filterCollection(Iterable<? extends SourceType> source, Filter<SourceType> filter) {
        return CollectionsUtil.filterAndConvertCollection(source, SAME, filter);
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> List<ResultType> convertCollection(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        return CollectionsUtil.filterAndConvertCollection(source, converter, CollectionsUtil.acceptAllFilter());
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Collection<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        Collection<? extends SourceType> iterable = source;
        return CollectionsUtil.convertSet(iterable, converter);
    }

    public static <ResultType, SourceType> Set<ResultType> convertSet(Iterable<? extends SourceType> source, Converter<ResultType, SourceType> converter) {
        HashSet result = CollectionsUtil.filterAndConvertCollection(source, new HashSet(), converter, CollectionsUtil.acceptAllFilter());
        return result != null ? Collections.unmodifiableSet(result) : null;
    }

    public static <SourceType> List<SourceType> collectUniqueObjectList(List<SourceType> list) {
        return new ArrayList<SourceType>(new LinkedHashSet<SourceType>(list));
    }

    @Nullable
    public static <T> T findFirst(Iterable<T> list, Filter<? super T> filter) {
        for (T element : list) {
            if (!filter.accept(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean contains(Iterable<T> iterable, Filter<? super T> filter) {
        return CollectionsUtil.findFirst(iterable, filter) != null;
    }

    public static <T extends Comparable<T>> void insertWithSorting(@NotNull T o, @NotNull List<T> list) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "jetbrains/buildServer/util/CollectionsUtil", "insertWithSorting"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "jetbrains/buildServer/util/CollectionsUtil", "insertWithSorting"));
        }
        for (int i = 0; i < list.size(); ++i) {
            if (o.compareTo(list.get(i)) >= 0) continue;
            list.add(i, o);
            return;
        }
        list.add(o);
    }

    public static <T> void insertWithSorting(@NotNull T o, @NotNull List<T> list, @NotNull Comparator<T> comp) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "jetbrains/buildServer/util/CollectionsUtil", "insertWithSorting"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "jetbrains/buildServer/util/CollectionsUtil", "insertWithSorting"));
        }
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "jetbrains/buildServer/util/CollectionsUtil", "insertWithSorting"));
        }
        for (int i = 0; i < list.size(); ++i) {
            if (comp.compare(o, list.get(i)) >= 0) continue;
            list.add(i, o);
            return;
        }
        list.add(o);
    }

    @NotNull
    public static String to_s(@NotNull Collection c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "jetbrains/buildServer/util/CollectionsUtil", "to_s"));
        }
        StringBuilder sb = new StringBuilder();
        if (c.size() > 0) {
            for (Object o : c) {
                sb.append("\r\n");
                sb.append(o.toString());
            }
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "to_s"));
        }
        return string;
    }

    @NotNull
    public static <T> List<List<T>> split(@NotNull List<T> toSplit, int numParts) {
        if (toSplit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSplit", "jetbrains/buildServer/util/CollectionsUtil", "split"));
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (toSplit.size() <= numParts) {
            result.add(toSplit);
            ArrayList<List<T>> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "split"));
            }
            return arrayList;
        }
        int lastIdx = 0;
        int step = toSplit.size() / numParts;
        if (toSplit.size() % numParts > 0) {
            ++step;
        }
        for (int i = 0; i < numParts; ++i) {
            int fromIdx = lastIdx;
            int toIdx = Math.min(fromIdx + step, toSplit.size());
            List<T> subList = toSplit.subList(fromIdx, toIdx);
            result.add(subList);
            lastIdx = toIdx;
            int leftItems = toSplit.size() - lastIdx;
            int leftParts = numParts - i - 1;
            if (leftParts <= 0) continue;
            step = leftItems / leftParts;
        }
        ArrayList<List<T>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "split"));
        }
        return arrayList;
    }

    public static void retainMatched(@Nullable Collection<String> stringCollection, @NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "jetbrains/buildServer/util/CollectionsUtil", "retainMatched"));
        }
        if (stringCollection == null || stringCollection.isEmpty()) {
            return;
        }
        Iterator<String> it = stringCollection.iterator();
        while (it.hasNext()) {
            if (pattern.matcher(it.next()).matches()) continue;
            it.remove();
        }
    }

    @NotNull
    public static <T> Set<T> minus(Collection<T> minuend, Set<T> subtrahend) {
        if (minuend == null || minuend.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "minus"));
            }
            return set;
        }
        if (minuend instanceof SortedSet) {
            SortedSet<T> sortedSet = CollectionsUtil.minus((SortedSet)minuend, subtrahend);
            if (sortedSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "minus"));
            }
            return sortedSet;
        }
        HashSet<T> remainder = new HashSet<T>(minuend.size());
        for (T item : minuend) {
            if (subtrahend.contains(item)) continue;
            remainder.add(item);
        }
        HashSet<T> hashSet = remainder;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "minus"));
        }
        return hashSet;
    }

    @NotNull
    public static <T> SortedSet<T> minus(SortedSet<T> minuend, Set<T> subtrahend) {
        TreeSet<T> remainder = new TreeSet<T>(minuend.comparator());
        for (Object item : minuend) {
            if (subtrahend.contains(item)) continue;
            remainder.add(item);
        }
        TreeSet<T> treeSet = remainder;
        if (treeSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "minus"));
        }
        return treeSet;
    }

    @NotNull
    public static <T> Set<T> intersect(@Nullable Collection<T> set1, @Nullable Collection<T> set2) {
        if (set1 == null || set1.isEmpty() || set2 == null || set2.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "intersect"));
            }
            return set;
        }
        HashSet<T> result = new HashSet<T>(Math.min(set1.size(), set2.size()));
        for (T item : set1) {
            if (!set2.contains(item)) continue;
            result.add(item);
        }
        HashSet<T> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "intersect"));
        }
        return hashSet;
    }

    @NotNull
    public static <T, Coll extends Iterable<T>> Coll removeNulls(@NotNull Coll collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "removeNulls"));
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        Coll Coll = collection;
        if (Coll == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "removeNulls"));
        }
        return Coll;
    }

    @NotNull
    public static <T> List<T> filterNulls(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "filterNulls"));
        }
        ArrayList<T> result = new ArrayList<T>(collection.size());
        for (T element : collection) {
            if (element == null) continue;
            result.add(element);
        }
        ArrayList<T> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "filterNulls"));
        }
        return arrayList;
    }

    @NotNull
    public static <Result, Source> List<Result> convertAndFilterNulls(@NotNull Iterable<Source> source, @NotNull Converter<Result, Source> converter) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/CollectionsUtil", "convertAndFilterNulls"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "jetbrains/buildServer/util/CollectionsUtil", "convertAndFilterNulls"));
        }
        List<Result> list = CollectionsUtil.filterNulls(CollectionsUtil.convertCollection(source, converter));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "convertAndFilterNulls"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public static <T> Collection<T> unite(Collection<? extends T> ... col) {
        void var5_8;
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "jetbrains/buildServer/util/CollectionsUtil", "unite"));
        }
        int size = 0;
        for (Collection<T> collection : col) {
            size += collection.size();
        }
        ArrayList<? extends T> union = new ArrayList<T>(size);
        Collection<? extends T>[] arr$ = col;
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_8 < len$) {
            Collection<? extends T> collection = arr$[var5_8];
            union.addAll(collection);
            ++var5_8;
        }
        ArrayList<? extends T> arrayList = union;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "unite"));
        }
        return arrayList;
    }

    public static <T, Q> List<T> applyOrder(@NotNull Q[] sortedIds, @NotNull List<T> allElements, @NotNull Map<Q, T> idToElementMap) {
        if (sortedIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sortedIds", "jetbrains/buildServer/util/CollectionsUtil", "applyOrder"));
        }
        if (allElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElements", "jetbrains/buildServer/util/CollectionsUtil", "applyOrder"));
        }
        if (idToElementMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToElementMap", "jetbrains/buildServer/util/CollectionsUtil", "applyOrder"));
        }
        ArrayList<T> newOrder = new ArrayList<T>();
        for (Q id : sortedIds) {
            T elem = idToElementMap.get(id);
            if (elem == null) continue;
            newOrder.add(elem);
        }
        int newOrderIdx = 0;
        ArrayList<T> result = new ArrayList<T>(allElements);
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (newOrderIdx >= newOrder.size() || newOrder.indexOf(item) == -1) continue;
            result.set(i, newOrder.get(newOrderIdx++));
        }
        return result;
    }

    @NotNull
    public static <T> Map<T, T> asMap(T ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "jetbrains/buildServer/util/CollectionsUtil", "asMap"));
        }
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("The number of arguments must be even");
        }
        LinkedHashMap<T, T> result = new LinkedHashMap<T, T>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            result.put(args[i], args[i + 1]);
        }
        LinkedHashMap<T, T> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "asMap"));
        }
        return linkedHashMap;
    }

    @NotNull
    public static <T> Set<T> setOf(T ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "jetbrains/buildServer/util/CollectionsUtil", "setOf"));
        }
        HashSet<T> hashSet = new HashSet<T>(Arrays.asList(args));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "setOf"));
        }
        return hashSet;
    }

    public static <T> void removeDuplicates(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "removeDuplicates"));
        }
        HashSet<T> set = new HashSet<T>(collection);
        collection.clear();
        collection.addAll(set);
    }

    @NotNull
    public static <T> Collection<T> removeDuplicatesPreservingOrder(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "removeDuplicatesPreservingOrder"));
        }
        if (collection instanceof Set || collection.isEmpty()) {
            Collection<T> collection2 = collection;
            if (collection2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "removeDuplicatesPreservingOrder"));
            }
            return collection2;
        }
        HashSet<T> set = new HashSet<T>(collection);
        if (set.size() == collection.size()) {
            Collection<T> collection3 = collection;
            if (collection3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "removeDuplicatesPreservingOrder"));
            }
            return collection3;
        }
        set.clear();
        ArrayList<Object> result = collection instanceof ArrayList ? (ArrayList<Object>)collection : new ArrayList<T>(collection);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (set.add(t)) continue;
            iterator.remove();
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "removeDuplicatesPreservingOrder"));
        }
        return arrayList;
    }

    public static <T> int binarySearch(@NotNull List<? extends T> list, @NotNull Condition<? super T> condition) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "jetbrains/buildServer/util/CollectionsUtil", "binarySearch"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "jetbrains/buildServer/util/CollectionsUtil", "binarySearch"));
        }
        int falseIndex = 0;
        int trueIndex = list.size();
        while (falseIndex < trueIndex) {
            int midIndex = falseIndex + trueIndex >> 1;
            if (condition.value(list.get(midIndex))) {
                trueIndex = midIndex;
                continue;
            }
            falseIndex = midIndex + 1;
        }
        return trueIndex;
    }

    @NotNull
    public static <T> Iterator<T> toTypedIterator(final @NotNull Class<T> clazz, final @NotNull Iterator data) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "jetbrains/buildServer/util/CollectionsUtil", "toTypedIterator"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/CollectionsUtil", "toTypedIterator"));
        }
        Iterator iterator = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return data.hasNext();
            }

            @Override
            public T next() {
                return clazz.cast(data.next());
            }

            @Override
            public void remove() {
                data.remove();
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "toTypedIterator"));
        }
        return iterator;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByKeys(@NotNull Map<K, V> map, @NotNull Filter<K> filter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByKeys"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByKeys"));
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, filter, CollectionsUtil.acceptAllFilter());
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByKeys"));
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMapByValues(@NotNull Map<K, V> map, @NotNull Filter<V> filter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByValues"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByValues"));
        }
        Map<K, V> map2 = CollectionsUtil.filterMap(map, CollectionsUtil.acceptAllFilter(), filter);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "filterMapByValues"));
        }
        return map2;
    }

    @NotNull
    public static <K, V> Map<K, V> filterMap(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/CollectionsUtil", "filterMap"));
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFilter", "jetbrains/buildServer/util/CollectionsUtil", "filterMap"));
        }
        if (valueFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueFilter", "jetbrains/buildServer/util/CollectionsUtil", "filterMap"));
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> kv : map.entrySet()) {
            if (!keyFilter.accept(kv.getKey()) || !valueFilter.accept(kv.getValue())) continue;
            result.put(kv.getKey(), kv.getValue());
        }
        LinkedHashMap<K, V> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "filterMap"));
        }
        return linkedHashMap;
    }

    public static <K, V> int count(@NotNull Map<K, V> map, @NotNull Filter<K> keyFilter, @NotNull Filter<V> valueFilter) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "jetbrains/buildServer/util/CollectionsUtil", "count"));
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyFilter", "jetbrains/buildServer/util/CollectionsUtil", "count"));
        }
        if (valueFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueFilter", "jetbrains/buildServer/util/CollectionsUtil", "count"));
        }
        int count = 0;
        for (Map.Entry<K, V> kv : map.entrySet()) {
            if (!keyFilter.accept(kv.getKey()) || !valueFilter.accept(kv.getValue())) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static <K, V> Map<K, List<V>> groupBy(@NotNull Collection<V> collection, @NotNull Converter<K, V> converter) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "jetbrains/buildServer/util/CollectionsUtil", "groupBy"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "jetbrains/buildServer/util/CollectionsUtil", "groupBy"));
        }
        LinkedHashMap<K, ArrayList<V>> result = new LinkedHashMap<K, ArrayList<V>>();
        for (V v : collection) {
            K k = converter.createFrom(v);
            ArrayList<V> group = (ArrayList<V>)result.get(k);
            if (group == null) {
                group = new ArrayList<V>();
                result.put(k, group);
            }
            group.add(v);
        }
        LinkedHashMap<K, ArrayList<V>> linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/CollectionsUtil", "groupBy"));
        }
        return linkedHashMap;
    }

    public static <K, V, K2, V2> void convertMap(@NotNull Map<? extends K, ? extends V> source, @NotNull Map<? super K2, ? super V2> target, @NotNull Converter<K2, K> keyConverter, @NotNull Converter<V2, V> valueConverter) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/util/CollectionsUtil", "convertMap"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "jetbrains/buildServer/util/CollectionsUtil", "convertMap"));
        }
        if (keyConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyConverter", "jetbrains/buildServer/util/CollectionsUtil", "convertMap"));
        }
        if (valueConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueConverter", "jetbrains/buildServer/util/CollectionsUtil", "convertMap"));
        }
        for (Map.Entry<K, V> e : source.entrySet()) {
            target.put(keyConverter.createFrom(e.getKey()), valueConverter.createFrom(e.getValue()));
        }
    }
}

