/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeExcludeRules {
    private final List<Rule> myRules;

    public IncludeExcludeRules(@NotNull String lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "jetbrains/buildServer/util/IncludeExcludeRules", "<init>"));
        }
        this.myRules = new ArrayList<Rule>();
        for (String line : StringUtil.split(lines, true, '\n', '\r')) {
            Rule rule;
            boolean include;
            String trimmed;
            String pattern = trimmed = line.trim();
            boolean bl = include = !trimmed.startsWith("-:");
            if (trimmed.startsWith("+:") || trimmed.startsWith("-:")) {
                pattern = trimmed.substring(2);
            }
            if (StringUtil.isEmpty((String)pattern) || this.myRules.contains(rule = new Rule(pattern, include))) continue;
            this.myRules.add(rule);
        }
    }

    @NotNull
    public List<Rule> getRules() {
        List<Rule> list = Collections.unmodifiableList(this.myRules);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/IncludeExcludeRules", "getRules"));
        }
        return list;
    }

    public static class Rule {
        private final String myRule;
        private final boolean myInclude;

        public Rule(@NotNull String rule, boolean include) {
            if (rule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "jetbrains/buildServer/util/IncludeExcludeRules$Rule", "<init>"));
            }
            this.myRule = rule;
            this.myInclude = include;
        }

        @NotNull
        public String getRule() {
            String string = this.myRule;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/IncludeExcludeRules$Rule", "getRule"));
            }
            return string;
        }

        public boolean isInclude() {
            return this.myInclude;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (this.myInclude != rule.myInclude) {
                return false;
            }
            return this.myRule.equals(rule.myRule);
        }

        public int hashCode() {
            int result = this.myRule.hashCode();
            result = 31 * result + (this.myInclude ? 1 : 0);
            return result;
        }
    }
}

