/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedThreadFactory
implements ThreadFactory {
    @NonNls
    private static final String EOL = System.getProperty("line.separator");
    private final AtomicInteger myCounter = new AtomicInteger(1);
    private final String myName;
    private final Map<Thread, Boolean> myThreads = new ConcurrentHashMap<Thread, Boolean>();
    private static final Logger LOG_ALLOC = Logger.getInstance((String)"jetbrains.buildServer.diagnostics.threadAllocations");

    public NamedThreadFactory(String name) {
        this.myName = name;
    }

    @Deprecated
    public static String updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadFactory", "updateThreadName"));
        }
        return NamedThreadUtil.updateThreadName(newDetails).getOldName();
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "jetbrains/buildServer/util/NamedThreadFactory", "newThread"));
        }
        this.cleanInactive();
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setName(this.myName + " " + this.myCounter.getAndIncrement());
        this.myThreads.put(thread, Boolean.TRUE);
        Thread thread2 = thread;
        if (thread2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadFactory", "newThread"));
        }
        return thread2;
    }

    public String getThreadDump() {
        this.cleanInactive();
        StringBuilder sb = new StringBuilder();
        for (Thread thread : this.myThreads.keySet()) {
            NamedThreadFactory.appendThreadStacktrace(sb, thread);
        }
        NamedThreadFactory.appendThreadStacktrace(sb, Thread.currentThread());
        sb.append(EOL);
        return sb.toString();
    }

    private static void appendThreadStacktrace(StringBuilder sb, Thread thread) {
        StackTraceElement[] trace;
        sb.append(thread.getName()).append(EOL);
        for (StackTraceElement aTrace : trace = thread.getStackTrace()) {
            sb.append("\tat ").append(aTrace).append(EOL);
        }
    }

    private void cleanInactive() {
        for (Thread thread : new HashSet<Thread>(this.myThreads.keySet())) {
            if (thread.isAlive()) continue;
            this.myThreads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithNewThreadName(@NotNull String newDetails, @NotNull Runnable action) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadFactory", "executeWithNewThreadName"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "jetbrains/buildServer/util/NamedThreadFactory", "executeWithNewThreadName"));
        }
        Disposable patch = NamedThreadFactory.patchThreadName(newDetails);
        try {
            action.run();
        }
        finally {
            patch.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithNewThreadName(@NotNull String newDetails, @NotNull Callable<T> action) throws Exception {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadFactory", "executeWithNewThreadName"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "jetbrains/buildServer/util/NamedThreadFactory", "executeWithNewThreadName"));
        }
        Disposable patch = NamedThreadFactory.patchThreadName(newDetails);
        try {
            T t = action.call();
            return t;
        }
        finally {
            patch.dispose();
        }
    }

    @NotNull
    public static Disposable patchThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDetails", "jetbrains/buildServer/util/NamedThreadFactory", "patchThreadName"));
        }
        boolean withStats = TeamCityProperties.getBoolean("teamcity.diagnostics.showThreadStatistics");
        final Disposable disposable = NamedThreadUtil.updateThreadName(newDetails, withStats);
        Disposable disposable2 = new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                try {
                    long allocated;
                    long[] threadStats = NamedThreadUtil.getThreadStatistics(Thread.currentThread(), null);
                    if (threadStats != null && (allocated = threadStats[0]) > NamedThreadFactory.getLogThreadAllocationThreshold()) {
                        LOG_ALLOC.info("\"" + Thread.currentThread().getName() + "\" allocated memory: " + StringUtil.formatFileSize(allocated));
                    }
                }
                finally {
                    disposable.dispose();
                }
            }
        };
        if (disposable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/NamedThreadFactory", "patchThreadName"));
        }
        return disposable2;
    }

    private static long getLogThreadAllocationThreshold() {
        return TeamCityProperties.getLong("teamcity.diagnostics.logThreadAllocThreshold", 0x40000000L);
    }
}

